/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntitySize {
    public final float width;
    public final float height;
    public final boolean fixed;

    public EntitySize(float var0, float var1, boolean var2) {
        this.width = var0;
        this.height = var1;
        this.fixed = var2;
    }

    public AxisAlignedBB makeBoundingBox(Vec3D var0) {
        return this.makeBoundingBox(var0.x, var0.y, var0.z);
    }

    public AxisAlignedBB makeBoundingBox(double var0, double var2, double var4) {
        float var6 = this.width / 2.0f;
        float var7 = this.height;
        return new AxisAlignedBB(var0 - (double)var6, var2, var4 - (double)var6, var0 + (double)var6, var2 + (double)var7, var4 + (double)var6);
    }

    public EntitySize scale(float var0) {
        return this.scale(var0, var0);
    }

    public EntitySize scale(float var0, float var1) {
        if (this.fixed || var0 == 1.0f && var1 == 1.0f) {
            return this;
        }
        return EntitySize.scalable(this.width * var0, this.height * var1);
    }

    public static EntitySize scalable(float var0, float var1) {
        return new EntitySize(var0, var1, false);
    }

    public static EntitySize fixed(float var0, float var1) {
        return new EntitySize(var0, var1, true);
    }

    public String toString() {
        return "EntityDimensions w=" + this.width + ", h=" + this.height + ", fixed=" + this.fixed;
    }
}

