/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.function.Consumer;
import net.minecraft.util.MathHelper;

public class AnimationState {
    private static final long STOPPED = Long.MAX_VALUE;
    private long lastTime = Long.MAX_VALUE;
    private long accumulatedTime;

    public void start(int var0) {
        this.lastTime = (long)var0 * 1000L / 20L;
        this.accumulatedTime = 0L;
    }

    public void startIfStopped(int var0) {
        if (!this.isStarted()) {
            this.start(var0);
        }
    }

    public void animateWhen(boolean var0, int var1) {
        if (var0) {
            this.startIfStopped(var1);
        } else {
            this.stop();
        }
    }

    public void stop() {
        this.lastTime = Long.MAX_VALUE;
    }

    public void ifStarted(Consumer<AnimationState> var0) {
        if (this.isStarted()) {
            var0.accept(this);
        }
    }

    public void updateTime(float var0, float var1) {
        if (!this.isStarted()) {
            return;
        }
        long var2 = MathHelper.lfloor(var0 * 1000.0f / 20.0f);
        this.accumulatedTime += (long)((float)(var2 - this.lastTime) * var1);
        this.lastTime = var2;
    }

    public long getAccumulatedTime() {
        return this.accumulatedTime;
    }

    public boolean isStarted() {
        return this.lastTime != Long.MAX_VALUE;
    }
}

