/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public abstract class DataConverterEntityRenameAbstract
extends DataFix {
    private final String name;

    public DataConverterEntityRenameAbstract(String var0, Schema var1, boolean var2) {
        super(var1, var2);
        this.name = var0;
    }

    public TypeRewriteRule makeRule() {
        TaggedChoice.TaggedChoiceType var0 = this.getInputSchema().findChoiceType(DataConverterTypes.ENTITY);
        TaggedChoice.TaggedChoiceType var1 = this.getOutputSchema().findChoiceType(DataConverterTypes.ENTITY);
        Type var22 = DSL.named((String)DataConverterTypes.ENTITY_NAME.typeName(), DataConverterSchemaNamed.namespacedString());
        if (!Objects.equals(this.getOutputSchema().getType(DataConverterTypes.ENTITY_NAME), var22)) {
            throw new IllegalStateException("Entity name type is not what was expected.");
        }
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhere(this.name, (Type)var0, (Type)var1, var2 -> var22 -> var22.mapFirst(var2 -> {
            String var3 = this.rename((String)var2);
            Type var4 = (Type)var0.types().get(var2);
            Type var5 = (Type)var1.types().get(var3);
            if (!var5.equals((Object)var4, true, true)) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Dynamic type check failed: %s not equal to %s", var5, var4));
            }
            return var3;
        })), (TypeRewriteRule)this.fixTypeEverywhere(this.name + " for entity name", var22, var02 -> var0 -> var0.mapSecond(this::rename)));
    }

    protected abstract String rename(String var1);
}

