/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.rcon.thread;

import com.mojang.logging.LogUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.rcon.StatusChallengeUtils;
import net.minecraft.server.rcon.thread.RemoteConnectionThread;
import org.slf4j.Logger;

public class RemoteControlSession
extends RemoteConnectionThread {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SERVERDATA_AUTH = 3;
    private static final int SERVERDATA_EXECCOMMAND = 2;
    private static final int SERVERDATA_RESPONSE_VALUE = 0;
    private static final int SERVERDATA_AUTH_RESPONSE = 2;
    private static final int SERVERDATA_AUTH_FAILURE = -1;
    private boolean authed;
    private final Socket client;
    private final byte[] buf = new byte[1460];
    private final String rconPassword;
    private final IMinecraftServer serverInterface;

    RemoteControlSession(IMinecraftServer var0, String var1, Socket var2) {
        super("RCON Client " + var2.getInetAddress());
        this.serverInterface = var0;
        this.client = var2;
        try {
            this.client.setSoTimeout(0);
        }
        catch (Exception var3) {
            this.running = false;
        }
        this.rconPassword = var1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.running) {
                BufferedInputStream var0 = new BufferedInputStream(this.client.getInputStream());
                int var1 = var0.read(this.buf, 0, 1460);
                if (10 > var1) {
                    return;
                }
                int var2 = 0;
                int var3 = StatusChallengeUtils.intFromByteArray(this.buf, 0, var1);
                if (var3 != var1 - 4) {
                    return;
                }
                int var4 = StatusChallengeUtils.intFromByteArray(this.buf, var2 += 4, var1);
                int var5 = StatusChallengeUtils.intFromByteArray(this.buf, var2 += 4);
                var2 += 4;
                switch (var5) {
                    case 3: {
                        String var6 = StatusChallengeUtils.stringFromByteArray(this.buf, var2, var1);
                        var2 += var6.length();
                        if (!var6.isEmpty() && var6.equals(this.rconPassword)) {
                            this.authed = true;
                            this.send(var4, 2, "");
                            break;
                        }
                        this.authed = false;
                        this.sendAuthFailure();
                        break;
                    }
                    case 2: {
                        if (this.authed) {
                            String var7 = StatusChallengeUtils.stringFromByteArray(this.buf, var2, var1);
                            try {
                                this.sendCmdResponse(var4, this.serverInterface.runCommand(var7));
                            }
                            catch (Exception var8) {
                                this.sendCmdResponse(var4, "Error executing: " + var7 + " (" + var8.getMessage() + ")");
                            }
                            break;
                        }
                        this.sendAuthFailure();
                        break;
                    }
                    default: {
                        this.sendCmdResponse(var4, String.format(Locale.ROOT, "Unknown request %s", Integer.toHexString(var5)));
                    }
                }
            }
        }
        catch (IOException var0) {
        }
        catch (Exception var0) {
            LOGGER.error("Exception whilst parsing RCON input", (Throwable)var0);
        }
        finally {
            this.closeSocket();
            LOGGER.info("Thread {} shutting down", (Object)this.name);
            this.running = false;
        }
    }

    private void send(int var0, int var1, String var2) throws IOException {
        ByteArrayOutputStream var3 = new ByteArrayOutputStream(1248);
        DataOutputStream var4 = new DataOutputStream(var3);
        byte[] var5 = var2.getBytes(StandardCharsets.UTF_8);
        var4.writeInt(Integer.reverseBytes(var5.length + 10));
        var4.writeInt(Integer.reverseBytes(var0));
        var4.writeInt(Integer.reverseBytes(var1));
        var4.write(var5);
        var4.write(0);
        var4.write(0);
        this.client.getOutputStream().write(var3.toByteArray());
    }

    private void sendAuthFailure() throws IOException {
        this.send(-1, 2, "");
    }

    private void sendCmdResponse(int var0, String var1) throws IOException {
        int var3;
        int var2 = var1.length();
        do {
            var3 = 4096 <= var2 ? 4096 : var2;
            this.send(var0, 0, var1.substring(0, var3));
        } while (0 != (var2 = (var1 = var1.substring(var3)).length()));
    }

    @Override
    public void stop() {
        this.running = false;
        this.closeSocket();
        super.stop();
    }

    private void closeSocket() {
        try {
            this.client.close();
        }
        catch (IOException var0) {
            LOGGER.warn("Failed to close socket", (Throwable)var0);
        }
    }
}

