/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.UUIDUtil;
import org.slf4j.Logger;

public class UserCache {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int GAMEPROFILES_MRU_LIMIT = 1000;
    private static final int GAMEPROFILES_EXPIRATION_MONTHS = 1;
    private static boolean usesAuthentication;
    private final Map<String, UserCacheEntry> profilesByName = Maps.newConcurrentMap();
    private final Map<UUID, UserCacheEntry> profilesByUUID = Maps.newConcurrentMap();
    private final Map<String, CompletableFuture<Optional<GameProfile>>> requests = Maps.newConcurrentMap();
    private final GameProfileRepository profileRepository;
    private final Gson gson = new GsonBuilder().create();
    private final File file;
    private final AtomicLong operationCount = new AtomicLong();
    @Nullable
    private Executor executor;

    public UserCache(GameProfileRepository var0, File var1) {
        this.profileRepository = var0;
        this.file = var1;
        Lists.reverse(this.load()).forEach(this::safeAdd);
    }

    private void safeAdd(UserCacheEntry var0) {
        GameProfile var1 = var0.getProfile();
        var0.setLastAccess(this.getNextOperation());
        this.profilesByName.put(var1.getName().toLowerCase(Locale.ROOT), var0);
        this.profilesByUUID.put(var1.getId(), var0);
    }

    private static Optional<GameProfile> lookupGameProfile(GameProfileRepository var0, String var1) {
        final AtomicReference var2 = new AtomicReference();
        ProfileLookupCallback var3 = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile var0) {
                var2.set(var0);
            }

            public void onProfileLookupFailed(String var0, Exception var1) {
                var2.set(null);
            }
        };
        var0.findProfilesByNames(new String[]{var1}, var3);
        GameProfile var4 = (GameProfile)var2.get();
        if (!UserCache.usesAuthentication() && var4 == null) {
            UUID var5 = UUIDUtil.createOfflinePlayerUUID(var1);
            return Optional.of(new GameProfile(var5, var1));
        }
        return Optional.ofNullable(var4);
    }

    public static void setUsesAuthentication(boolean var0) {
        usesAuthentication = var0;
    }

    private static boolean usesAuthentication() {
        return usesAuthentication;
    }

    public void add(GameProfile var0) {
        Calendar var1 = Calendar.getInstance();
        var1.setTime(new Date());
        var1.add(2, 1);
        Date var2 = var1.getTime();
        UserCacheEntry var3 = new UserCacheEntry(var0, var2);
        this.safeAdd(var3);
        this.save();
    }

    private long getNextOperation() {
        return this.operationCount.incrementAndGet();
    }

    public Optional<GameProfile> get(String var0) {
        Optional<GameProfile> var4;
        String var1 = var0.toLowerCase(Locale.ROOT);
        UserCacheEntry var2 = this.profilesByName.get(var1);
        boolean var3 = false;
        if (var2 != null && new Date().getTime() >= var2.expirationDate.getTime()) {
            this.profilesByUUID.remove(var2.getProfile().getId());
            this.profilesByName.remove(var2.getProfile().getName().toLowerCase(Locale.ROOT));
            var3 = true;
            var2 = null;
        }
        if (var2 != null) {
            var2.setLastAccess(this.getNextOperation());
            var4 = Optional.of(var2.getProfile());
        } else {
            var4 = UserCache.lookupGameProfile(this.profileRepository, var1);
            if (var4.isPresent()) {
                this.add(var4.get());
                var3 = false;
            }
        }
        if (var3) {
            this.save();
        }
        return var4;
    }

    public CompletableFuture<Optional<GameProfile>> getAsync(String var0) {
        if (this.executor == null) {
            throw new IllegalStateException("No executor");
        }
        CompletableFuture<Optional<GameProfile>> var12 = this.requests.get(var0);
        if (var12 != null) {
            return var12;
        }
        CompletionStage var22 = CompletableFuture.supplyAsync(() -> this.get(var0), SystemUtils.backgroundExecutor()).whenCompleteAsync((var1, var2) -> this.requests.remove(var0), this.executor);
        this.requests.put(var0, (CompletableFuture<Optional<GameProfile>>)var22);
        return var22;
    }

    public Optional<GameProfile> get(UUID var0) {
        UserCacheEntry var1 = this.profilesByUUID.get(var0);
        if (var1 == null) {
            return Optional.empty();
        }
        var1.setLastAccess(this.getNextOperation());
        return Optional.of(var1.getProfile());
    }

    public void setExecutor(Executor var0) {
        this.executor = var0;
    }

    public void clearExecutor() {
        this.executor = null;
    }

    private static DateFormat createDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<UserCacheEntry> load() {
        ArrayList var0 = Lists.newArrayList();
        try (BufferedReader var12222 = Files.newReader((File)this.file, (Charset)StandardCharsets.UTF_8);){
            JsonArray var22 = (JsonArray)this.gson.fromJson((Reader)var12222, JsonArray.class);
            if (var22 == null) {
                ArrayList arrayList = var0;
                return arrayList;
            }
            DateFormat var3 = UserCache.createDateFormat();
            var22.forEach(var2 -> UserCache.readGameProfile(var2, var3).ifPresent(var0::add));
            return var0;
        }
        catch (FileNotFoundException var12222) {
            return var0;
        }
        catch (JsonParseException | IOException var13) {
            LOGGER.warn("Failed to load profile cache {}", (Object)this.file, (Object)var13);
        }
        return var0;
    }

    public void save() {
        JsonArray var0 = new JsonArray();
        DateFormat var1 = UserCache.createDateFormat();
        this.getTopMRUProfiles(1000).forEach(var2 -> var0.add(UserCache.writeGameProfile(var2, var1)));
        String var22 = this.gson.toJson((JsonElement)var0);
        try (BufferedWriter var3 = Files.newWriter((File)this.file, (Charset)StandardCharsets.UTF_8);){
            var3.write(var22);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Stream<UserCacheEntry> getTopMRUProfiles(int var0) {
        return ImmutableList.copyOf(this.profilesByUUID.values()).stream().sorted(Comparator.comparing(UserCacheEntry::getLastAccess).reversed()).limit(var0);
    }

    private static JsonElement writeGameProfile(UserCacheEntry var0, DateFormat var1) {
        JsonObject var2 = new JsonObject();
        var2.addProperty("name", var0.getProfile().getName());
        var2.addProperty("uuid", var0.getProfile().getId().toString());
        var2.addProperty("expiresOn", var1.format(var0.getExpirationDate()));
        return var2;
    }

    private static Optional<UserCacheEntry> readGameProfile(JsonElement var0, DateFormat var1) {
        if (var0.isJsonObject()) {
            UUID var9;
            JsonObject var2 = var0.getAsJsonObject();
            JsonElement var3 = var2.get("name");
            JsonElement var4 = var2.get("uuid");
            JsonElement var5 = var2.get("expiresOn");
            if (var3 == null || var4 == null) {
                return Optional.empty();
            }
            String var6 = var4.getAsString();
            String var7 = var3.getAsString();
            Date var8 = null;
            if (var5 != null) {
                try {
                    var8 = var1.parse(var5.getAsString());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (var7 == null || var6 == null || var8 == null) {
                return Optional.empty();
            }
            try {
                var9 = UUID.fromString(var6);
            }
            catch (Throwable var10) {
                return Optional.empty();
            }
            return Optional.of(new UserCacheEntry(new GameProfile(var9, var7), var8));
        }
        return Optional.empty();
    }

    static class UserCacheEntry {
        private final GameProfile profile;
        final Date expirationDate;
        private volatile long lastAccess;

        UserCacheEntry(GameProfile var0, Date var1) {
            this.profile = var0;
            this.expirationDate = var1;
        }

        public GameProfile getProfile() {
            return this.profile;
        }

        public Date getExpirationDate() {
            return this.expirationDate;
        }

        public void setLastAccess(long var0) {
            this.lastAccess = var0;
        }

        public long getLastAccess() {
            return this.lastAccess;
        }
    }
}

