/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.players.ExpirableListEntry;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.WhiteList;
import net.minecraft.server.players.WhiteListEntry;
import net.minecraft.util.UtilColor;
import net.minecraft.world.level.storage.SavedFile;
import org.slf4j.Logger;

public class NameReferencingFileConverter {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final File OLD_IPBANLIST = new File("banned-ips.txt");
    public static final File OLD_USERBANLIST = new File("banned-players.txt");
    public static final File OLD_OPLIST = new File("ops.txt");
    public static final File OLD_WHITELIST = new File("white-list.txt");

    static List<String> readOldListFormat(File var0, Map<String, String[]> var1) throws IOException {
        List var2 = Files.readLines((File)var0, (Charset)StandardCharsets.UTF_8);
        for (String var4 : var2) {
            if ((var4 = var4.trim()).startsWith("#") || var4.length() < 1) continue;
            String[] var5 = var4.split("\\|");
            var1.put(var5[0].toLowerCase(Locale.ROOT), var5);
        }
        return var2;
    }

    private static void lookupPlayers(MinecraftServer var02, Collection<String> var1, ProfileLookupCallback var2) {
        String[] var3 = (String[])var1.stream().filter(var0 -> !UtilColor.isNullOrEmpty(var0)).toArray(String[]::new);
        if (var02.usesAuthentication()) {
            var02.getProfileRepository().findProfilesByNames(var3, var2);
        } else {
            for (String var7 : var3) {
                UUID var8 = UUIDUtil.createOfflinePlayerUUID(var7);
                GameProfile var9 = new GameProfile(var8, var7);
                var2.onProfileLookupSucceeded(var9);
            }
        }
    }

    public static boolean convertUserBanlist(final MinecraftServer var0) {
        final GameProfileBanList var1 = new GameProfileBanList(PlayerList.USERBANLIST_FILE);
        if (OLD_USERBANLIST.exists() && OLD_USERBANLIST.isFile()) {
            if (var1.getFile().exists()) {
                try {
                    var1.load();
                }
                catch (IOException var2) {
                    LOGGER.warn("Could not load existing file {}", (Object)var1.getFile().getName(), (Object)var2);
                }
            }
            try {
                final HashMap var2 = Maps.newHashMap();
                NameReferencingFileConverter.readOldListFormat(OLD_USERBANLIST, var2);
                ProfileLookupCallback var3 = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile var02) {
                        var0.getProfileCache().add(var02);
                        String[] var12 = (String[])var2.get(var02.getName().toLowerCase(Locale.ROOT));
                        if (var12 == null) {
                            LOGGER.warn("Could not convert user banlist entry for {}", (Object)var02.getName());
                            throw new FileConversionException("Profile not in the conversionlist");
                        }
                        Date var22 = var12.length > 1 ? NameReferencingFileConverter.parseDate(var12[1], null) : null;
                        String var3 = var12.length > 2 ? var12[2] : null;
                        Date var4 = var12.length > 3 ? NameReferencingFileConverter.parseDate(var12[3], null) : null;
                        String var5 = var12.length > 4 ? var12[4] : null;
                        var1.add(new GameProfileBanEntry(var02, var22, var3, var4, var5));
                    }

                    public void onProfileLookupFailed(String var02, Exception var12) {
                        LOGGER.warn("Could not lookup user banlist entry for {}", (Object)var02, (Object)var12);
                        if (!(var12 instanceof ProfileNotFoundException)) {
                            throw new FileConversionException("Could not request user " + var02 + " from backend systems", var12);
                        }
                    }
                };
                NameReferencingFileConverter.lookupPlayers(var0, var2.keySet(), var3);
                var1.save();
                NameReferencingFileConverter.renameOldFile(OLD_USERBANLIST);
            }
            catch (IOException var2) {
                LOGGER.warn("Could not read old user banlist to convert it!", (Throwable)var2);
                return false;
            }
            catch (FileConversionException var2) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)var2);
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean convertIpBanlist(MinecraftServer var0) {
        IpBanList var1 = new IpBanList(PlayerList.IPBANLIST_FILE);
        if (OLD_IPBANLIST.exists() && OLD_IPBANLIST.isFile()) {
            if (var1.getFile().exists()) {
                try {
                    var1.load();
                }
                catch (IOException var2) {
                    LOGGER.warn("Could not load existing file {}", (Object)var1.getFile().getName(), (Object)var2);
                }
            }
            try {
                HashMap var2 = Maps.newHashMap();
                NameReferencingFileConverter.readOldListFormat(OLD_IPBANLIST, var2);
                for (String var4 : var2.keySet()) {
                    String[] var5 = (String[])var2.get(var4);
                    Date var6 = var5.length > 1 ? NameReferencingFileConverter.parseDate(var5[1], null) : null;
                    String var7 = var5.length > 2 ? var5[2] : null;
                    Date var8 = var5.length > 3 ? NameReferencingFileConverter.parseDate(var5[3], null) : null;
                    String var9 = var5.length > 4 ? var5[4] : null;
                    var1.add(new IpBanEntry(var4, var6, var7, var8, var9));
                }
                var1.save();
                NameReferencingFileConverter.renameOldFile(OLD_IPBANLIST);
            }
            catch (IOException var2) {
                LOGGER.warn("Could not parse old ip banlist to convert it!", (Throwable)var2);
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean convertOpsList(final MinecraftServer var0) {
        final OpList var1 = new OpList(PlayerList.OPLIST_FILE);
        if (OLD_OPLIST.exists() && OLD_OPLIST.isFile()) {
            if (var1.getFile().exists()) {
                try {
                    var1.load();
                }
                catch (IOException var2) {
                    LOGGER.warn("Could not load existing file {}", (Object)var1.getFile().getName(), (Object)var2);
                }
            }
            try {
                List var2 = Files.readLines((File)OLD_OPLIST, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback var3 = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile var02) {
                        var0.getProfileCache().add(var02);
                        var1.add(new OpListEntry(var02, var0.getOperatorUserPermissionLevel(), false));
                    }

                    public void onProfileLookupFailed(String var02, Exception var12) {
                        LOGGER.warn("Could not lookup oplist entry for {}", (Object)var02, (Object)var12);
                        if (!(var12 instanceof ProfileNotFoundException)) {
                            throw new FileConversionException("Could not request user " + var02 + " from backend systems", var12);
                        }
                    }
                };
                NameReferencingFileConverter.lookupPlayers(var0, var2, var3);
                var1.save();
                NameReferencingFileConverter.renameOldFile(OLD_OPLIST);
            }
            catch (IOException var2) {
                LOGGER.warn("Could not read old oplist to convert it!", (Throwable)var2);
                return false;
            }
            catch (FileConversionException var2) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)var2);
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean convertWhiteList(final MinecraftServer var0) {
        final WhiteList var1 = new WhiteList(PlayerList.WHITELIST_FILE);
        if (OLD_WHITELIST.exists() && OLD_WHITELIST.isFile()) {
            if (var1.getFile().exists()) {
                try {
                    var1.load();
                }
                catch (IOException var2) {
                    LOGGER.warn("Could not load existing file {}", (Object)var1.getFile().getName(), (Object)var2);
                }
            }
            try {
                List var2 = Files.readLines((File)OLD_WHITELIST, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback var3 = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile var02) {
                        var0.getProfileCache().add(var02);
                        var1.add(new WhiteListEntry(var02));
                    }

                    public void onProfileLookupFailed(String var02, Exception var12) {
                        LOGGER.warn("Could not lookup user whitelist entry for {}", (Object)var02, (Object)var12);
                        if (!(var12 instanceof ProfileNotFoundException)) {
                            throw new FileConversionException("Could not request user " + var02 + " from backend systems", var12);
                        }
                    }
                };
                NameReferencingFileConverter.lookupPlayers(var0, var2, var3);
                var1.save();
                NameReferencingFileConverter.renameOldFile(OLD_WHITELIST);
            }
            catch (IOException var2) {
                LOGGER.warn("Could not read old whitelist to convert it!", (Throwable)var2);
                return false;
            }
            catch (FileConversionException var2) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)var2);
                return false;
            }
            return true;
        }
        return true;
    }

    @Nullable
    public static UUID convertMobOwnerIfNecessary(final MinecraftServer var0, String var1) {
        if (UtilColor.isNullOrEmpty(var1) || var1.length() > 16) {
            try {
                return UUID.fromString(var1);
            }
            catch (IllegalArgumentException var2) {
                return null;
            }
        }
        Optional<UUID> var2 = var0.getProfileCache().get(var1).map(GameProfile::getId);
        if (var2.isPresent()) {
            return var2.get();
        }
        if (var0.isSingleplayer() || !var0.usesAuthentication()) {
            return UUIDUtil.createOfflinePlayerUUID(var1);
        }
        final ArrayList var3 = Lists.newArrayList();
        ProfileLookupCallback var4 = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile var02) {
                var0.getProfileCache().add(var02);
                var3.add(var02);
            }

            public void onProfileLookupFailed(String var02, Exception var1) {
                LOGGER.warn("Could not lookup user whitelist entry for {}", (Object)var02, (Object)var1);
            }
        };
        NameReferencingFileConverter.lookupPlayers(var0, Lists.newArrayList((Object[])new String[]{var1}), var4);
        if (!var3.isEmpty()) {
            return ((GameProfile)var3.get(0)).getId();
        }
        return null;
    }

    public static boolean convertPlayers(final DedicatedServer var0) {
        final File var1 = NameReferencingFileConverter.getWorldPlayersDirectory(var0);
        final File var2 = new File(var1.getParentFile(), "playerdata");
        final File var3 = new File(var1.getParentFile(), "unknownplayers");
        if (!var1.exists() || !var1.isDirectory()) {
            return true;
        }
        File[] var4 = var1.listFiles();
        ArrayList var5 = Lists.newArrayList();
        for (File var9 : var4) {
            String var11;
            String var10 = var9.getName();
            if (!var10.toLowerCase(Locale.ROOT).endsWith(".dat") || (var11 = var10.substring(0, var10.length() - ".dat".length())).isEmpty()) continue;
            var5.add(var11);
        }
        try {
            Object[] var6 = var5.toArray(new String[var5.size()]);
            ProfileLookupCallback var7 = new ProfileLookupCallback((String[])var6){
                final /* synthetic */ String[] e;
                {
                    this.e = stringArray;
                }

                public void onProfileLookupSucceeded(GameProfile var02) {
                    var0.getProfileCache().add(var02);
                    UUID var12 = var02.getId();
                    this.movePlayerFile(var2, this.getFileNameForProfile(var02.getName()), var12.toString());
                }

                public void onProfileLookupFailed(String var02, Exception var12) {
                    LOGGER.warn("Could not lookup user uuid for {}", (Object)var02, (Object)var12);
                    if (!(var12 instanceof ProfileNotFoundException)) {
                        throw new FileConversionException("Could not request user " + var02 + " from backend systems", var12);
                    }
                    String var22 = this.getFileNameForProfile(var02);
                    this.movePlayerFile(var3, var22, var22);
                }

                private void movePlayerFile(File var02, String var12, String var22) {
                    File var32 = new File(var1, var12 + ".dat");
                    File var4 = new File(var02, var22 + ".dat");
                    NameReferencingFileConverter.ensureDirectoryExists(var02);
                    if (!var32.renameTo(var4)) {
                        throw new FileConversionException("Could not convert file for " + var12);
                    }
                }

                private String getFileNameForProfile(String var02) {
                    String var12 = null;
                    for (String var5 : this.e) {
                        if (var5 == null || !var5.equalsIgnoreCase(var02)) continue;
                        var12 = var5;
                        break;
                    }
                    if (var12 == null) {
                        throw new FileConversionException("Could not find the filename for " + var02 + " anymore");
                    }
                    return var12;
                }
            };
            NameReferencingFileConverter.lookupPlayers(var0, Lists.newArrayList((Object[])var6), var7);
        }
        catch (FileConversionException var6) {
            LOGGER.error("Conversion failed, please try again later", (Throwable)var6);
            return false;
        }
        return true;
    }

    static void ensureDirectoryExists(File var0) {
        if (var0.exists()) {
            if (var0.isDirectory()) {
                return;
            }
            throw new FileConversionException("Can't create directory " + var0.getName() + " in world save directory.");
        }
        if (!var0.mkdirs()) {
            throw new FileConversionException("Can't create directory " + var0.getName() + " in world save directory.");
        }
    }

    public static boolean serverReadyAfterUserconversion(MinecraftServer var0) {
        boolean var1 = NameReferencingFileConverter.areOldUserlistsRemoved();
        var1 = var1 && NameReferencingFileConverter.areOldPlayersConverted(var0);
        return var1;
    }

    private static boolean areOldUserlistsRemoved() {
        boolean var0 = false;
        if (OLD_USERBANLIST.exists() && OLD_USERBANLIST.isFile()) {
            var0 = true;
        }
        boolean var1 = false;
        if (OLD_IPBANLIST.exists() && OLD_IPBANLIST.isFile()) {
            var1 = true;
        }
        boolean var2 = false;
        if (OLD_OPLIST.exists() && OLD_OPLIST.isFile()) {
            var2 = true;
        }
        boolean var3 = false;
        if (OLD_WHITELIST.exists() && OLD_WHITELIST.isFile()) {
            var3 = true;
        }
        if (var0 || var1 || var2 || var3) {
            LOGGER.warn("**** FAILED TO START THE SERVER AFTER ACCOUNT CONVERSION!");
            LOGGER.warn("** please remove the following files and restart the server:");
            if (var0) {
                LOGGER.warn("* {}", (Object)OLD_USERBANLIST.getName());
            }
            if (var1) {
                LOGGER.warn("* {}", (Object)OLD_IPBANLIST.getName());
            }
            if (var2) {
                LOGGER.warn("* {}", (Object)OLD_OPLIST.getName());
            }
            if (var3) {
                LOGGER.warn("* {}", (Object)OLD_WHITELIST.getName());
            }
            return false;
        }
        return true;
    }

    private static boolean areOldPlayersConverted(MinecraftServer var0) {
        File var1 = NameReferencingFileConverter.getWorldPlayersDirectory(var0);
        if (var1.exists() && var1.isDirectory() && (var1.list().length > 0 || !var1.delete())) {
            LOGGER.warn("**** DETECTED OLD PLAYER DIRECTORY IN THE WORLD SAVE");
            LOGGER.warn("**** THIS USUALLY HAPPENS WHEN THE AUTOMATIC CONVERSION FAILED IN SOME WAY");
            LOGGER.warn("** please restart the server and if the problem persists, remove the directory '{}'", (Object)var1.getPath());
            return false;
        }
        return true;
    }

    private static File getWorldPlayersDirectory(MinecraftServer var0) {
        return var0.getWorldPath(SavedFile.PLAYER_OLD_DATA_DIR).toFile();
    }

    private static void renameOldFile(File var0) {
        File var1 = new File(var0.getName() + ".converted");
        var0.renameTo(var1);
    }

    static Date parseDate(String var0, Date var1) {
        Date var2;
        try {
            var2 = ExpirableListEntry.DATE_FORMAT.parse(var0);
        }
        catch (ParseException var3) {
            var2 = var1;
        }
        return var2;
    }

    static class FileConversionException
    extends RuntimeException {
        FileConversionException(String var0, Throwable var1) {
            super(var0, var1);
        }

        FileConversionException(String var0) {
            super(var0);
        }
    }
}

