/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.primitives.Ints;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.logging.LogUtils;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.login.PacketLoginInEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginInListener;
import net.minecraft.network.protocol.login.PacketLoginInStart;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginOutSetCompression;
import net.minecraft.network.protocol.login.PacketLoginOutSuccess;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.ServerboundLoginAcknowledgedPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.RandomSource;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class LoginListener
implements PacketLoginInListener,
TickablePacketListener {
    private static final AtomicInteger UNIQUE_THREAD_ID = new AtomicInteger(0);
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_TICKS_BEFORE_LOGIN = 600;
    private static final IChatBaseComponent DISCONNECT_UNEXPECTED_QUERY = IChatBaseComponent.translatable("multiplayer.disconnect.unexpected_query_response");
    private final byte[] challenge;
    final MinecraftServer server;
    public final NetworkManager connection;
    private volatile EnumProtocolState state = EnumProtocolState.HELLO;
    private int tick;
    @Nullable
    String requestedUsername;
    @Nullable
    private GameProfile authenticatedProfile;
    private final String serverId = "";

    public LoginListener(MinecraftServer var0, NetworkManager var1) {
        this.server = var0;
        this.connection = var1;
        this.challenge = Ints.toByteArray((int)RandomSource.create().nextInt());
    }

    @Override
    public void tick() {
        if (this.state == EnumProtocolState.VERIFYING) {
            this.verifyLoginAndFinishConnectionSetup(Objects.requireNonNull(this.authenticatedProfile));
        }
        if (this.state == EnumProtocolState.WAITING_FOR_DUPE_DISCONNECT && !this.isPlayerAlreadyInWorld(Objects.requireNonNull(this.authenticatedProfile))) {
            this.finishLoginAndWaitForClient(this.authenticatedProfile);
        }
        if (this.tick++ == 600) {
            this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.slow_login"));
        }
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected();
    }

    public void disconnect(IChatBaseComponent var0) {
        try {
            LOGGER.info("Disconnecting {}: {}", (Object)this.getUserName(), (Object)var0.getString());
            this.connection.send(new PacketLoginOutDisconnect(var0));
            this.connection.disconnect(var0);
        }
        catch (Exception var1) {
            LOGGER.error("Error whilst disconnecting player", (Throwable)var1);
        }
    }

    private boolean isPlayerAlreadyInWorld(GameProfile var0) {
        return this.server.getPlayerList().getPlayer(var0.getId()) != null;
    }

    @Override
    public void onDisconnect(IChatBaseComponent var0) {
        LOGGER.info("{} lost connection: {}", (Object)this.getUserName(), (Object)var0.getString());
    }

    public String getUserName() {
        String var0 = this.connection.getLoggableAddress(this.server.logIPs());
        if (this.requestedUsername != null) {
            return this.requestedUsername + " (" + var0 + ")";
        }
        return var0;
    }

    @Override
    public void handleHello(PacketLoginInStart var0) {
        Validate.validState((this.state == EnumProtocolState.HELLO ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        Validate.validState((boolean)LoginListener.isValidUsername(var0.name()), (String)"Invalid characters in username", (Object[])new Object[0]);
        this.requestedUsername = var0.name();
        GameProfile var1 = this.server.getSingleplayerProfile();
        if (var1 != null && this.requestedUsername.equalsIgnoreCase(var1.getName())) {
            this.startClientVerification(var1);
            return;
        }
        if (this.server.usesAuthentication() && !this.connection.isMemoryConnection()) {
            this.state = EnumProtocolState.KEY;
            this.connection.send(new PacketLoginOutEncryptionBegin("", this.server.getKeyPair().getPublic().getEncoded(), this.challenge));
        } else {
            this.startClientVerification(LoginListener.createOfflineProfile(this.requestedUsername));
        }
    }

    void startClientVerification(GameProfile var0) {
        this.authenticatedProfile = var0;
        this.state = EnumProtocolState.VERIFYING;
    }

    private void verifyLoginAndFinishConnectionSetup(GameProfile var0) {
        PlayerList var1 = this.server.getPlayerList();
        IChatBaseComponent var2 = var1.canPlayerLogin(this.connection.getRemoteAddress(), var0);
        if (var2 != null) {
            this.disconnect(var2);
        } else {
            boolean var3;
            if (this.server.getCompressionThreshold() >= 0 && !this.connection.isMemoryConnection()) {
                this.connection.send(new PacketLoginOutSetCompression(this.server.getCompressionThreshold()), PacketSendListener.thenRun(() -> this.connection.setupCompression(this.server.getCompressionThreshold(), true)));
            }
            if (var3 = var1.disconnectAllPlayersWithProfile(var0)) {
                this.state = EnumProtocolState.WAITING_FOR_DUPE_DISCONNECT;
            } else {
                this.finishLoginAndWaitForClient(var0);
            }
        }
    }

    private void finishLoginAndWaitForClient(GameProfile var0) {
        this.state = EnumProtocolState.PROTOCOL_SWITCHING;
        this.connection.send(new PacketLoginOutSuccess(var0));
    }

    public static boolean isValidUsername(String var02) {
        return var02.chars().filter(var0 -> var0 <= 32 || var0 >= 127).findAny().isEmpty();
    }

    @Override
    public void handleKey(PacketLoginInEncryptionBegin var0) {
        String var1;
        Object var2;
        Validate.validState((this.state == EnumProtocolState.KEY ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            var2 = this.server.getKeyPair().getPrivate();
            if (!var0.isChallengeValid(this.challenge, (PrivateKey)var2)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey var3 = var0.getSecretKey((PrivateKey)var2);
            Cipher var4 = MinecraftEncryption.getCipher(2, var3);
            Cipher var5 = MinecraftEncryption.getCipher(1, var3);
            var1 = new BigInteger(MinecraftEncryption.digestData("", this.server.getKeyPair().getPublic(), var3)).toString(16);
            this.state = EnumProtocolState.AUTHENTICATING;
            this.connection.setEncryptionKey(var4, var5);
        }
        catch (CryptographyException var22) {
            throw new IllegalStateException("Protocol error", var22);
        }
        var2 = new Thread("User Authenticator #" + UNIQUE_THREAD_ID.incrementAndGet()){

            @Override
            public void run() {
                String var0 = Objects.requireNonNull(LoginListener.this.requestedUsername, "Player name not initialized");
                try {
                    ProfileResult var12 = LoginListener.this.server.getSessionService().hasJoinedServer(var0, var1, this.getAddress());
                    if (var12 != null) {
                        GameProfile var2 = var12.profile();
                        LOGGER.info("UUID of player {} is {}", (Object)var2.getName(), (Object)var2.getId());
                        LoginListener.this.startClientVerification(var2);
                    } else if (LoginListener.this.server.isSingleplayer()) {
                        LOGGER.warn("Failed to verify username but will let them in anyway!");
                        LoginListener.this.startClientVerification(LoginListener.createOfflineProfile(var0));
                    } else {
                        LoginListener.this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.unverified_username"));
                        LOGGER.error("Username '{}' tried to join with an invalid session", (Object)var0);
                    }
                }
                catch (AuthenticationUnavailableException var13) {
                    if (LoginListener.this.server.isSingleplayer()) {
                        LOGGER.warn("Authentication servers are down but will let them in anyway!");
                        LoginListener.this.startClientVerification(LoginListener.createOfflineProfile(var0));
                    }
                    LoginListener.this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.authservers_down"));
                    LOGGER.error("Couldn't verify username because servers are unavailable");
                }
            }

            @Nullable
            private InetAddress getAddress() {
                SocketAddress var0 = LoginListener.this.connection.getRemoteAddress();
                return LoginListener.this.server.getPreventProxyConnections() && var0 instanceof InetSocketAddress ? ((InetSocketAddress)var0).getAddress() : null;
            }
        };
        ((Thread)var2).setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        ((Thread)var2).start();
    }

    @Override
    public void handleCustomQueryPacket(ServerboundCustomQueryAnswerPacket var0) {
        this.disconnect(DISCONNECT_UNEXPECTED_QUERY);
    }

    @Override
    public void handleLoginAcknowledgement(ServerboundLoginAcknowledgedPacket var0) {
        Validate.validState((this.state == EnumProtocolState.PROTOCOL_SWITCHING ? 1 : 0) != 0, (String)"Unexpected login acknowledgement packet", (Object[])new Object[0]);
        CommonListenerCookie var1 = CommonListenerCookie.createInitial(Objects.requireNonNull(this.authenticatedProfile));
        ServerConfigurationPacketListenerImpl var2 = new ServerConfigurationPacketListenerImpl(this.server, this.connection, var1);
        this.connection.setListener(var2);
        var2.startConfiguration();
        this.state = EnumProtocolState.ACCEPTED;
    }

    protected static GameProfile createOfflineProfile(String var0) {
        UUID var1 = UUIDUtil.createOfflinePlayerUUID(var0);
        return new GameProfile(var1, var0);
    }

    static final class EnumProtocolState
    extends Enum<EnumProtocolState> {
        public static final /* enum */ EnumProtocolState HELLO = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState KEY = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState AUTHENTICATING = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState NEGOTIATING = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState VERIFYING = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState WAITING_FOR_DUPE_DISCONNECT = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState PROTOCOL_SWITCHING = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState ACCEPTED = new EnumProtocolState();
        private static final /* synthetic */ EnumProtocolState[] i;

        public static EnumProtocolState[] values() {
            return (EnumProtocolState[])i.clone();
        }

        public static EnumProtocolState valueOf(String var0) {
            return Enum.valueOf(EnumProtocolState.class, var0);
        }

        private static /* synthetic */ EnumProtocolState[] a() {
            return new EnumProtocolState[]{HELLO, KEY, AUTHENTICATING, NEGOTIATING, VERIFYING, WAITING_FOR_DUPE_DISCONNECT, PROTOCOL_SWITCHING, ACCEPTED};
        }

        static {
            i = EnumProtocolState.a();
        }
    }
}

