/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.PropertyManager;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import org.slf4j.Logger;

public class DedicatedServerProperties
extends PropertyManager<DedicatedServerProperties> {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final Pattern SHA1 = Pattern.compile("^[a-fA-F0-9]{40}$");
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').trimResults();
    public final boolean onlineMode = this.get("online-mode", true);
    public final boolean preventProxyConnections = this.get("prevent-proxy-connections", false);
    public final String serverIp = this.get("server-ip", "");
    public final boolean spawnAnimals = this.get("spawn-animals", true);
    public final boolean spawnNpcs = this.get("spawn-npcs", true);
    public final boolean pvp = this.get("pvp", true);
    public final boolean allowFlight = this.get("allow-flight", false);
    public final String motd = this.get("motd", "A Minecraft Server");
    public final boolean forceGameMode = this.get("force-gamemode", false);
    public final boolean enforceWhitelist = this.get("enforce-whitelist", false);
    public final EnumDifficulty difficulty = this.get("difficulty", DedicatedServerProperties.dispatchNumberOrString(EnumDifficulty::byId, EnumDifficulty::byName), EnumDifficulty::getKey, EnumDifficulty.EASY);
    public final EnumGamemode gamemode = this.get("gamemode", DedicatedServerProperties.dispatchNumberOrString(EnumGamemode::byId, EnumGamemode::byName), EnumGamemode::getName, EnumGamemode.SURVIVAL);
    public final String levelName = this.get("level-name", "world");
    public final int serverPort = this.get("server-port", 25565);
    @Nullable
    public final Boolean announcePlayerAchievements = this.getLegacyBoolean("announce-player-achievements");
    public final boolean enableQuery = this.get("enable-query", false);
    public final int queryPort = this.get("query.port", 25565);
    public final boolean enableRcon = this.get("enable-rcon", false);
    public final int rconPort = this.get("rcon.port", 25575);
    public final String rconPassword = this.get("rcon.password", "");
    public final boolean hardcore = this.get("hardcore", false);
    public final boolean allowNether = this.get("allow-nether", true);
    public final boolean spawnMonsters = this.get("spawn-monsters", true);
    public final boolean useNativeTransport = this.get("use-native-transport", true);
    public final boolean enableCommandBlock = this.get("enable-command-block", false);
    public final int spawnProtection = this.get("spawn-protection", 16);
    public final int opPermissionLevel = this.get("op-permission-level", 4);
    public final int functionPermissionLevel = this.get("function-permission-level", 2);
    public final long maxTickTime = this.get("max-tick-time", TimeUnit.MINUTES.toMillis(1L));
    public final int maxChainedNeighborUpdates = this.get("max-chained-neighbor-updates", 1000000);
    public final int rateLimitPacketsPerSecond = this.get("rate-limit", 0);
    public final int viewDistance = this.get("view-distance", 10);
    public final int simulationDistance = this.get("simulation-distance", 10);
    public final int maxPlayers = this.get("max-players", 20);
    public final int networkCompressionThreshold = this.get("network-compression-threshold", 256);
    public final boolean broadcastRconToOps = this.get("broadcast-rcon-to-ops", true);
    public final boolean broadcastConsoleToOps = this.get("broadcast-console-to-ops", true);
    public final int maxWorldSize = this.get("max-world-size", var0 -> MathHelper.clamp(var0, 1, 29999984), 29999984);
    public final boolean syncChunkWrites = this.get("sync-chunk-writes", true);
    public final boolean enableJmxMonitoring = this.get("enable-jmx-monitoring", false);
    public final boolean enableStatus = this.get("enable-status", true);
    public final boolean hideOnlinePlayers = this.get("hide-online-players", false);
    public final int entityBroadcastRangePercentage = this.get("entity-broadcast-range-percentage", var0 -> MathHelper.clamp(var0, 10, 1000), 100);
    public final String textFilteringConfig = this.get("text-filtering-config", "");
    public final Optional<MinecraftServer.ServerResourcePackInfo> serverResourcePackInfo;
    public final DataPackConfiguration initialDataPackConfiguration;
    public final PropertyManager.EditableProperty<Integer> playerIdleTimeout = this.getMutable("player-idle-timeout", 0);
    public final PropertyManager.EditableProperty<Boolean> whiteList = this.getMutable("white-list", false);
    public final boolean enforceSecureProfile = this.get("enforce-secure-profile", true);
    public final boolean logIPs = this.get("log-ips", true);
    private final WorldDimensionData worldDimensionData;
    public final WorldOptions worldOptions;

    public DedicatedServerProperties(Properties var02) {
        super(var02);
        String var1 = this.get("level-seed", "");
        boolean var2 = this.get("generate-structures", true);
        long var3 = WorldOptions.parseSeed(var1).orElse(WorldOptions.randomSeed());
        this.worldOptions = new WorldOptions(var3, var2, false);
        this.worldDimensionData = new WorldDimensionData(this.get("generator-settings", (String var0) -> ChatDeserializer.parse(!var0.isEmpty() ? var0 : "{}"), new JsonObject()), this.get("level-type", (String var0) -> var0.toLowerCase(Locale.ROOT), WorldPresets.NORMAL.location().toString()));
        this.serverResourcePackInfo = DedicatedServerProperties.getServerPackInfo(this.get("resource-pack", ""), this.get("resource-pack-sha1", ""), this.getLegacyString("resource-pack-hash"), this.get("require-resource-pack", false), this.get("resource-pack-prompt", ""));
        this.initialDataPackConfiguration = DedicatedServerProperties.getDatapackConfig(this.get("initial-enabled-packs", String.join((CharSequence)",", WorldDataConfiguration.DEFAULT.dataPacks().getEnabled())), this.get("initial-disabled-packs", String.join((CharSequence)",", WorldDataConfiguration.DEFAULT.dataPacks().getDisabled())));
    }

    public static DedicatedServerProperties fromFile(Path var0) {
        return new DedicatedServerProperties(DedicatedServerProperties.loadFromFile(var0));
    }

    @Override
    protected DedicatedServerProperties reload(IRegistryCustom var0, Properties var1) {
        return new DedicatedServerProperties(var1);
    }

    @Nullable
    private static IChatBaseComponent parseResourcePackPrompt(String var0) {
        if (!Strings.isNullOrEmpty((String)var0)) {
            try {
                return IChatBaseComponent.ChatSerializer.fromJson(var0);
            }
            catch (Exception var1) {
                LOGGER.warn("Failed to parse resource pack prompt '{}'", (Object)var0, (Object)var1);
            }
        }
        return null;
    }

    private static Optional<MinecraftServer.ServerResourcePackInfo> getServerPackInfo(String var0, String var1, @Nullable String var2, boolean var3, String var4) {
        String var5;
        if (var0.isEmpty()) {
            return Optional.empty();
        }
        if (!var1.isEmpty()) {
            var5 = var1;
            if (!Strings.isNullOrEmpty((String)var2)) {
                LOGGER.warn("resource-pack-hash is deprecated and found along side resource-pack-sha1. resource-pack-hash will be ignored.");
            }
        } else if (!Strings.isNullOrEmpty((String)var2)) {
            LOGGER.warn("resource-pack-hash is deprecated. Please use resource-pack-sha1 instead.");
            var5 = var2;
        } else {
            var5 = "";
        }
        if (var5.isEmpty()) {
            LOGGER.warn("You specified a resource pack without providing a sha1 hash. Pack will be updated on the client only if you change the name of the pack.");
        } else if (!SHA1.matcher(var5).matches()) {
            LOGGER.warn("Invalid sha1 for resource-pack-sha1");
        }
        IChatBaseComponent var6 = DedicatedServerProperties.parseResourcePackPrompt(var4);
        return Optional.of(new MinecraftServer.ServerResourcePackInfo(var0, var5, var3, var6));
    }

    private static DataPackConfiguration getDatapackConfig(String var0, String var1) {
        List var2 = COMMA_SPLITTER.splitToList((CharSequence)var0);
        List var3 = COMMA_SPLITTER.splitToList((CharSequence)var1);
        return new DataPackConfiguration(var2, var3);
    }

    private static FeatureFlagSet getFeatures(String var02) {
        return FeatureFlags.REGISTRY.fromNames(COMMA_SPLITTER.splitToStream((CharSequence)var02).mapMulti((var0, var1) -> {
            MinecraftKey var2 = MinecraftKey.tryParse(var0);
            if (var2 == null) {
                LOGGER.warn("Invalid resource location {}, ignoring", var0);
            } else {
                var1.accept(var2);
            }
        }).collect(Collectors.toList()));
    }

    public WorldDimensions createDimensions(IRegistryCustom var0) {
        return this.worldDimensionData.create(var0);
    }

    @Override
    protected /* synthetic */ PropertyManager reload(IRegistryCustom iRegistryCustom, Properties properties) {
        return this.reload(iRegistryCustom, properties);
    }

    public record WorldDimensionData(JsonObject generatorSettings, String levelType) {
        private static final Map<String, ResourceKey<WorldPreset>> LEGACY_PRESET_NAMES = Map.of("default", WorldPresets.NORMAL, "largebiomes", WorldPresets.LARGE_BIOMES);

        public WorldDimensions create(IRegistryCustom var02) {
            IRegistry<WorldPreset> var1 = var02.registryOrThrow(Registries.WORLD_PRESET);
            Holder.c<WorldPreset> var2 = var1.getHolder(WorldPresets.NORMAL).or(() -> var1.holders().findAny()).orElseThrow(() -> new IllegalStateException("Invalid datapack contents: can't find default preset"));
            Holder var3 = Optional.ofNullable(MinecraftKey.tryParse(this.levelType)).map(var0 -> ResourceKey.create(Registries.WORLD_PRESET, var0)).or(() -> Optional.ofNullable(LEGACY_PRESET_NAMES.get(this.levelType))).flatMap(var1::getHolder).orElseGet(() -> {
                LOGGER.warn("Failed to parse level-type {}, defaulting to {}", (Object)this.levelType, (Object)var2.key().location());
                return var2;
            });
            WorldDimensions var4 = ((WorldPreset)var3.value()).createWorldDimensions();
            if (var3.is(WorldPresets.FLAT)) {
                RegistryOps var5 = RegistryOps.create(JsonOps.INSTANCE, var02);
                Optional var6 = GeneratorSettingsFlat.CODEC.parse(new Dynamic(var5, (Object)this.generatorSettings())).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0));
                if (var6.isPresent()) {
                    return var4.replaceOverworldGenerator(var02, new ChunkProviderFlat((GeneratorSettingsFlat)var6.get()));
                }
            }
            return var4;
        }
    }
}

