/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomSequences;

public class RandomCommand {
    private static final SimpleCommandExceptionType ERROR_RANGE_TOO_LARGE = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.random.error.range_too_large"));
    private static final SimpleCommandExceptionType ERROR_RANGE_TOO_SMALL = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.random.error.range_too_small"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("random").then(RandomCommand.drawRandomValueTree("value", false))).then(RandomCommand.drawRandomValueTree("roll", true))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("reset").requires(var0 -> var0.hasPermission(2))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("*").executes(var0 -> RandomCommand.resetAllSequences((CommandListenerWrapper)var0.getSource()))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("seed", IntegerArgumentType.integer()).executes(var0 -> RandomCommand.resetAllSequencesAndSetNewDefaults((CommandListenerWrapper)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"seed"), true, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("includeWorldSeed", BoolArgumentType.bool()).executes(var0 -> RandomCommand.resetAllSequencesAndSetNewDefaults((CommandListenerWrapper)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"seed"), BoolArgumentType.getBool((CommandContext)var0, (String)"includeWorldSeed"), true))).then(net.minecraft.commands.CommandDispatcher.argument("includeSequenceId", BoolArgumentType.bool()).executes(var0 -> RandomCommand.resetAllSequencesAndSetNewDefaults((CommandListenerWrapper)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"seed"), BoolArgumentType.getBool((CommandContext)var0, (String)"includeWorldSeed"), BoolArgumentType.getBool((CommandContext)var0, (String)"includeSequenceId")))))))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("sequence", ArgumentMinecraftKeyRegistered.id()).suggests(RandomCommand::suggestRandomSequence).executes(var0 -> RandomCommand.resetSequence((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "sequence")))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("seed", IntegerArgumentType.integer()).executes(var0 -> RandomCommand.resetSequence((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "sequence"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"seed"), true, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("includeWorldSeed", BoolArgumentType.bool()).executes(var0 -> RandomCommand.resetSequence((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "sequence"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"seed"), BoolArgumentType.getBool((CommandContext)var0, (String)"includeWorldSeed"), true))).then(net.minecraft.commands.CommandDispatcher.argument("includeSequenceId", BoolArgumentType.bool()).executes(var0 -> RandomCommand.resetSequence((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "sequence"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"seed"), BoolArgumentType.getBool((CommandContext)var0, (String)"includeWorldSeed"), BoolArgumentType.getBool((CommandContext)var0, (String)"includeSequenceId")))))))));
    }

    private static LiteralArgumentBuilder<CommandListenerWrapper> drawRandomValueTree(String var02, boolean var12) {
        return (LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal(var02).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("range", ArgumentCriterionValue.intRange()).executes(var1 -> RandomCommand.randomSample((CommandListenerWrapper)var1.getSource(), ArgumentCriterionValue.b.getRange((CommandContext<CommandListenerWrapper>)var1, "range"), null, var12))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("sequence", ArgumentMinecraftKeyRegistered.id()).suggests(RandomCommand::suggestRandomSequence).requires(var0 -> var0.hasPermission(2))).executes(var1 -> RandomCommand.randomSample((CommandListenerWrapper)var1.getSource(), ArgumentCriterionValue.b.getRange((CommandContext<CommandListenerWrapper>)var1, "range"), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var1, "sequence"), var12))));
    }

    private static CompletableFuture<Suggestions> suggestRandomSequence(CommandContext<CommandListenerWrapper> var0, SuggestionsBuilder var12) {
        ArrayList var22 = Lists.newArrayList();
        ((CommandListenerWrapper)var0.getSource()).getLevel().getRandomSequences().forAllSequences((var1, var2) -> var22.add(var1.toString()));
        return ICompletionProvider.suggest(var22, var12);
    }

    private static int randomSample(CommandListenerWrapper var0, CriterionConditionValue.IntegerRange var1, @Nullable MinecraftKey var2, boolean var3) throws CommandSyntaxException {
        RandomSource var4 = var2 != null ? var0.getLevel().getRandomSequence(var2) : var0.getLevel().getRandom();
        int var5 = var1.min().orElse(Integer.MIN_VALUE);
        int var6 = var1.max().orElse(Integer.MAX_VALUE);
        long var7 = (long)var6 - (long)var5;
        if (var7 == 0L) {
            throw ERROR_RANGE_TOO_SMALL.create();
        }
        if (var7 >= Integer.MAX_VALUE) {
            throw ERROR_RANGE_TOO_LARGE.create();
        }
        int var9 = MathHelper.randomBetweenInclusive(var4, var5, var6);
        if (var3) {
            var0.getServer().getPlayerList().broadcastSystemMessage(IChatBaseComponent.translatable("commands.random.roll", var0.getDisplayName(), var9, var5, var6), false);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.random.sample.success", var9), false);
        }
        return var9;
    }

    private static int resetSequence(CommandListenerWrapper var0, MinecraftKey var1) throws CommandSyntaxException {
        var0.getLevel().getRandomSequences().reset(var1);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.random.reset.success", var1), false);
        return 1;
    }

    private static int resetSequence(CommandListenerWrapper var0, MinecraftKey var1, int var2, boolean var3, boolean var4) throws CommandSyntaxException {
        var0.getLevel().getRandomSequences().reset(var1, var2, var3, var4);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.random.reset.success", var1), false);
        return 1;
    }

    private static int resetAllSequences(CommandListenerWrapper var0) {
        int var1 = var0.getLevel().getRandomSequences().clear();
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.random.reset.all.success", var1), false);
        return var1;
    }

    private static int resetAllSequencesAndSetNewDefaults(CommandListenerWrapper var0, int var1, boolean var2, boolean var3) {
        RandomSequences var4 = var0.getLevel().getRandomSequences();
        var4.setSeedDefaults(var1, var2, var3);
        int var5 = var4.clear();
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.random.reset.all.success", var5), false);
        return var5;
    }
}

