/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import org.apache.commons.lang3.mutable.MutableInt;

public class FillBiomeCommand {
    public static final SimpleCommandExceptionType ERROR_NOT_LOADED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.pos.unloaded"));
    private static final Dynamic2CommandExceptionType ERROR_VOLUME_TOO_LARGE = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatable("commands.fillbiome.toobig", var0, var1));

    public static void register(CommandDispatcher<CommandListenerWrapper> var03, CommandBuildContext var1) {
        var03.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("fillbiome").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("from", ArgumentPosition.blockPos()).then(net.minecraft.commands.CommandDispatcher.argument("to", ArgumentPosition.blockPos()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("biome", ResourceArgument.resource(var1, Registries.BIOME)).executes(var02 -> FillBiomeCommand.fill((CommandListenerWrapper)var02.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "from"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "to"), ResourceArgument.getResource((CommandContext<CommandListenerWrapper>)var02, "biome", Registries.BIOME), var0 -> true))).then(net.minecraft.commands.CommandDispatcher.literal("replace").then(net.minecraft.commands.CommandDispatcher.argument("filter", ResourceOrTagArgument.resourceOrTag(var1, Registries.BIOME)).executes(var0 -> FillBiomeCommand.fill((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "from"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "to"), ResourceArgument.getResource((CommandContext<CommandListenerWrapper>)var0, "biome", Registries.BIOME), ResourceOrTagArgument.getResourceOrTag((CommandContext<CommandListenerWrapper>)var0, "filter", Registries.BIOME)::test))))))));
    }

    private static int quantize(int var0) {
        return QuartPos.toBlock(QuartPos.fromBlock(var0));
    }

    private static BlockPosition quantize(BlockPosition var0) {
        return new BlockPosition(FillBiomeCommand.quantize(var0.getX()), FillBiomeCommand.quantize(var0.getY()), FillBiomeCommand.quantize(var0.getZ()));
    }

    private static BiomeResolver makeResolver(MutableInt var0, IChunkAccess var1, StructureBoundingBox var2, Holder<BiomeBase> var3, Predicate<Holder<BiomeBase>> var4) {
        return (var5, var6, var7, var8) -> {
            int var9 = QuartPos.toBlock(var5);
            int var10 = QuartPos.toBlock(var6);
            int var11 = QuartPos.toBlock(var7);
            Holder<BiomeBase> var12 = var1.getNoiseBiome(var5, var6, var7);
            if (var2.isInside(var9, var10, var11) && var4.test(var12)) {
                var0.increment();
                return var3;
            }
            return var12;
        };
    }

    private static int fill(CommandListenerWrapper var0, BlockPosition var1, BlockPosition var2, Holder.c<BiomeBase> var3, Predicate<Holder<BiomeBase>> var4) throws CommandSyntaxException {
        int var9;
        BlockPosition var6;
        BlockPosition var5 = FillBiomeCommand.quantize(var1);
        StructureBoundingBox var7 = StructureBoundingBox.fromCorners(var5, var6 = FillBiomeCommand.quantize(var2));
        int var8 = var7.getXSpan() * var7.getYSpan() * var7.getZSpan();
        if (var8 > (var9 = var0.getLevel().getGameRules().getInt(GameRules.RULE_COMMAND_MODIFICATION_BLOCK_LIMIT))) {
            throw ERROR_VOLUME_TOO_LARGE.create((Object)var9, (Object)var8);
        }
        WorldServer var10 = var0.getLevel();
        ArrayList<IChunkAccess> var11 = new ArrayList<IChunkAccess>();
        for (int var12 = SectionPosition.blockToSectionCoord(var7.minZ()); var12 <= SectionPosition.blockToSectionCoord(var7.maxZ()); ++var12) {
            for (int var13 = SectionPosition.blockToSectionCoord(var7.minX()); var13 <= SectionPosition.blockToSectionCoord(var7.maxX()); ++var13) {
                IChunkAccess var14 = var10.getChunk(var13, var12, ChunkStatus.FULL, false);
                if (var14 == null) {
                    throw ERROR_NOT_LOADED.create();
                }
                var11.add(var14);
            }
        }
        MutableInt var12 = new MutableInt(0);
        for (IChunkAccess var14 : var11) {
            var14.fillBiomesFromNoise(FillBiomeCommand.makeResolver(var12, var14, var7, var3, var4), var10.getChunkSource().randomState().sampler());
            var14.setUnsaved(true);
        }
        var10.getChunkSource().chunkMap.resendBiomesForChunks(var11);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.fillbiome.success.count", var12.getValue(), var7.minX(), var7.minY(), var7.minZ(), var7.maxX(), var7.maxY(), var7.maxZ()), true);
        return var12.getValue();
    }
}

