/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentMathOperation;
import net.minecraft.commands.arguments.ArgumentScoreboardCriteria;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreboardSlot;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;

public class CommandScoreboard {
    private static final SimpleCommandExceptionType ERROR_OBJECTIVE_ALREADY_EXISTS = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.scoreboard.objectives.add.duplicate"));
    private static final SimpleCommandExceptionType ERROR_DISPLAY_SLOT_ALREADY_EMPTY = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.scoreboard.objectives.display.alreadyEmpty"));
    private static final SimpleCommandExceptionType ERROR_DISPLAY_SLOT_ALREADY_SET = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.scoreboard.objectives.display.alreadySet"));
    private static final SimpleCommandExceptionType ERROR_TRIGGER_ALREADY_ENABLED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.scoreboard.players.enable.failed"));
    private static final SimpleCommandExceptionType ERROR_NOT_TRIGGER = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.scoreboard.players.enable.invalid"));
    private static final Dynamic2CommandExceptionType ERROR_NO_VALUE = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatable("commands.scoreboard.players.get.null", var0, var1));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("scoreboard").requires(var0 -> var0.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("objectives").then(net.minecraft.commands.CommandDispatcher.literal("list").executes(var0 -> CommandScoreboard.listObjectives((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.literal("add").then(net.minecraft.commands.CommandDispatcher.argument("objective", StringArgumentType.word()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("criteria", ArgumentScoreboardCriteria.criteria()).executes(var0 -> CommandScoreboard.addObjective((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"objective"), ArgumentScoreboardCriteria.getCriteria((CommandContext<CommandListenerWrapper>)var0, "criteria"), IChatBaseComponent.literal(StringArgumentType.getString((CommandContext)var0, (String)"objective"))))).then(net.minecraft.commands.CommandDispatcher.argument("displayName", ArgumentChatComponent.textComponent()).executes(var0 -> CommandScoreboard.addObjective((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"objective"), ArgumentScoreboardCriteria.getCriteria((CommandContext<CommandListenerWrapper>)var0, "criteria"), ArgumentChatComponent.getComponent((CommandContext<CommandListenerWrapper>)var0, "displayName")))))))).then(net.minecraft.commands.CommandDispatcher.literal("modify").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("objective", ArgumentScoreboardObjective.objective()).then(net.minecraft.commands.CommandDispatcher.literal("displayname").then(net.minecraft.commands.CommandDispatcher.argument("displayName", ArgumentChatComponent.textComponent()).executes(var0 -> CommandScoreboard.setDisplayName((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardObjective.getObjective((CommandContext<CommandListenerWrapper>)var0, "objective"), ArgumentChatComponent.getComponent((CommandContext<CommandListenerWrapper>)var0, "displayName")))))).then(CommandScoreboard.createRenderTypeModify())))).then(net.minecraft.commands.CommandDispatcher.literal("remove").then(net.minecraft.commands.CommandDispatcher.argument("objective", ArgumentScoreboardObjective.objective()).executes(var0 -> CommandScoreboard.removeObjective((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardObjective.getObjective((CommandContext<CommandListenerWrapper>)var0, "objective")))))).then(net.minecraft.commands.CommandDispatcher.literal("setdisplay").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("slot", ArgumentScoreboardSlot.displaySlot()).executes(var0 -> CommandScoreboard.clearDisplaySlot((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardSlot.getDisplaySlot((CommandContext<CommandListenerWrapper>)var0, "slot")))).then(net.minecraft.commands.CommandDispatcher.argument("objective", ArgumentScoreboardObjective.objective()).executes(var0 -> CommandScoreboard.setDisplaySlot((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardSlot.getDisplaySlot((CommandContext<CommandListenerWrapper>)var0, "slot"), ArgumentScoreboardObjective.getObjective((CommandContext<CommandListenerWrapper>)var0, "objective")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("players").then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("list").executes(var0 -> CommandScoreboard.listTrackedPlayers((CommandListenerWrapper)var0.getSource()))).then(net.minecraft.commands.CommandDispatcher.argument("target", ArgumentScoreholder.scoreHolder()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).executes(var0 -> CommandScoreboard.listTrackedPlayerScores((CommandListenerWrapper)var0.getSource(), ArgumentScoreholder.getName((CommandContext<CommandListenerWrapper>)var0, "target")))))).then(net.minecraft.commands.CommandDispatcher.literal("set").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentScoreholder.scoreHolders()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(net.minecraft.commands.CommandDispatcher.argument("objective", ArgumentScoreboardObjective.objective()).then(net.minecraft.commands.CommandDispatcher.argument("score", IntegerArgumentType.integer()).executes(var0 -> CommandScoreboard.setScore((CommandListenerWrapper)var0.getSource(), ArgumentScoreholder.getNamesWithDefaultWildcard((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentScoreboardObjective.getWritableObjective((CommandContext<CommandListenerWrapper>)var0, "objective"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"score")))))))).then(net.minecraft.commands.CommandDispatcher.literal("get").then(net.minecraft.commands.CommandDispatcher.argument("target", ArgumentScoreholder.scoreHolder()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(net.minecraft.commands.CommandDispatcher.argument("objective", ArgumentScoreboardObjective.objective()).executes(var0 -> CommandScoreboard.getScore((CommandListenerWrapper)var0.getSource(), ArgumentScoreholder.getName((CommandContext<CommandListenerWrapper>)var0, "target"), ArgumentScoreboardObjective.getObjective((CommandContext<CommandListenerWrapper>)var0, "objective"))))))).then(net.minecraft.commands.CommandDispatcher.literal("add").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentScoreholder.scoreHolders()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(net.minecraft.commands.CommandDispatcher.argument("objective", ArgumentScoreboardObjective.objective()).then(net.minecraft.commands.CommandDispatcher.argument("score", IntegerArgumentType.integer((int)0)).executes(var0 -> CommandScoreboard.addScore((CommandListenerWrapper)var0.getSource(), ArgumentScoreholder.getNamesWithDefaultWildcard((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentScoreboardObjective.getWritableObjective((CommandContext<CommandListenerWrapper>)var0, "objective"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"score")))))))).then(net.minecraft.commands.CommandDispatcher.literal("remove").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentScoreholder.scoreHolders()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(net.minecraft.commands.CommandDispatcher.argument("objective", ArgumentScoreboardObjective.objective()).then(net.minecraft.commands.CommandDispatcher.argument("score", IntegerArgumentType.integer((int)0)).executes(var0 -> CommandScoreboard.removeScore((CommandListenerWrapper)var0.getSource(), ArgumentScoreholder.getNamesWithDefaultWildcard((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentScoreboardObjective.getWritableObjective((CommandContext<CommandListenerWrapper>)var0, "objective"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"score")))))))).then(net.minecraft.commands.CommandDispatcher.literal("reset").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentScoreholder.scoreHolders()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).executes(var0 -> CommandScoreboard.resetScores((CommandListenerWrapper)var0.getSource(), ArgumentScoreholder.getNamesWithDefaultWildcard((CommandContext<CommandListenerWrapper>)var0, "targets")))).then(net.minecraft.commands.CommandDispatcher.argument("objective", ArgumentScoreboardObjective.objective()).executes(var0 -> CommandScoreboard.resetScore((CommandListenerWrapper)var0.getSource(), ArgumentScoreholder.getNamesWithDefaultWildcard((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentScoreboardObjective.getObjective((CommandContext<CommandListenerWrapper>)var0, "objective"))))))).then(net.minecraft.commands.CommandDispatcher.literal("enable").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentScoreholder.scoreHolders()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(net.minecraft.commands.CommandDispatcher.argument("objective", ArgumentScoreboardObjective.objective()).suggests((var0, var1) -> CommandScoreboard.suggestTriggers((CommandListenerWrapper)var0.getSource(), ArgumentScoreholder.getNamesWithDefaultWildcard((CommandContext<CommandListenerWrapper>)var0, "targets"), var1)).executes(var0 -> CommandScoreboard.enableTrigger((CommandListenerWrapper)var0.getSource(), ArgumentScoreholder.getNamesWithDefaultWildcard((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentScoreboardObjective.getObjective((CommandContext<CommandListenerWrapper>)var0, "objective"))))))).then(net.minecraft.commands.CommandDispatcher.literal("operation").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentScoreholder.scoreHolders()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(net.minecraft.commands.CommandDispatcher.argument("targetObjective", ArgumentScoreboardObjective.objective()).then(net.minecraft.commands.CommandDispatcher.argument("operation", ArgumentMathOperation.operation()).then(net.minecraft.commands.CommandDispatcher.argument("source", ArgumentScoreholder.scoreHolders()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).then(net.minecraft.commands.CommandDispatcher.argument("sourceObjective", ArgumentScoreboardObjective.objective()).executes(var0 -> CommandScoreboard.performOperation((CommandListenerWrapper)var0.getSource(), ArgumentScoreholder.getNamesWithDefaultWildcard((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentScoreboardObjective.getWritableObjective((CommandContext<CommandListenerWrapper>)var0, "targetObjective"), ArgumentMathOperation.getOperation((CommandContext<CommandListenerWrapper>)var0, "operation"), ArgumentScoreholder.getNamesWithDefaultWildcard((CommandContext<CommandListenerWrapper>)var0, "source"), ArgumentScoreboardObjective.getObjective((CommandContext<CommandListenerWrapper>)var0, "sourceObjective")))))))))));
    }

    private static LiteralArgumentBuilder<CommandListenerWrapper> createRenderTypeModify() {
        LiteralArgumentBuilder<CommandListenerWrapper> var0 = net.minecraft.commands.CommandDispatcher.literal("rendertype");
        for (IScoreboardCriteria.EnumScoreboardHealthDisplay var4 : IScoreboardCriteria.EnumScoreboardHealthDisplay.values()) {
            var0.then(net.minecraft.commands.CommandDispatcher.literal(var4.getId()).executes(var1 -> CommandScoreboard.setRenderType((CommandListenerWrapper)var1.getSource(), ArgumentScoreboardObjective.getObjective((CommandContext<CommandListenerWrapper>)var1, "objective"), var4)));
        }
        return var0;
    }

    private static CompletableFuture<Suggestions> suggestTriggers(CommandListenerWrapper var0, Collection<String> var1, SuggestionsBuilder var2) {
        ArrayList var3 = Lists.newArrayList();
        ScoreboardServer var4 = var0.getServer().getScoreboard();
        for (ScoreboardObjective var6 : var4.getObjectives()) {
            if (var6.getCriteria() != IScoreboardCriteria.TRIGGER) continue;
            boolean var7 = false;
            for (String var9 : var1) {
                if (var4.hasPlayerScore(var9, var6) && !var4.getOrCreatePlayerScore(var9, var6).isLocked()) continue;
                var7 = true;
                break;
            }
            if (!var7) continue;
            var3.add(var6.getName());
        }
        return ICompletionProvider.suggest(var3, var2);
    }

    private static int getScore(CommandListenerWrapper var0, String var1, ScoreboardObjective var2) throws CommandSyntaxException {
        ScoreboardServer var3 = var0.getServer().getScoreboard();
        if (!var3.hasPlayerScore(var1, var2)) {
            throw ERROR_NO_VALUE.create((Object)var2.getName(), (Object)var1);
        }
        ScoreboardScore var4 = var3.getOrCreatePlayerScore(var1, var2);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.get.success", var1, var4.getScore(), var2.getFormattedDisplayName()), false);
        return var4.getScore();
    }

    private static int performOperation(CommandListenerWrapper var0, Collection<String> var1, ScoreboardObjective var2, ArgumentMathOperation.a var3, Collection<String> var4, ScoreboardObjective var5) throws CommandSyntaxException {
        ScoreboardServer var6 = var0.getServer().getScoreboard();
        int var7 = 0;
        for (String var9 : var1) {
            ScoreboardScore var10 = var6.getOrCreatePlayerScore(var9, var2);
            for (String var12 : var4) {
                ScoreboardScore var13 = var6.getOrCreatePlayerScore(var12, var5);
                var3.apply(var10, var13);
            }
            var7 += var10.getScore();
        }
        if (var1.size() == 1) {
            int var8 = var7;
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.operation.success.single", var2.getFormattedDisplayName(), var1.iterator().next(), var8), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.operation.success.multiple", var2.getFormattedDisplayName(), var1.size()), true);
        }
        return var7;
    }

    private static int enableTrigger(CommandListenerWrapper var0, Collection<String> var1, ScoreboardObjective var2) throws CommandSyntaxException {
        if (var2.getCriteria() != IScoreboardCriteria.TRIGGER) {
            throw ERROR_NOT_TRIGGER.create();
        }
        ScoreboardServer var3 = var0.getServer().getScoreboard();
        int var4 = 0;
        for (String var6 : var1) {
            ScoreboardScore var7 = var3.getOrCreatePlayerScore(var6, var2);
            if (!var7.isLocked()) continue;
            var7.setLocked(false);
            ++var4;
        }
        if (var4 == 0) {
            throw ERROR_TRIGGER_ALREADY_ENABLED.create();
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.enable.success.single", var2.getFormattedDisplayName(), var1.iterator().next()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.enable.success.multiple", var2.getFormattedDisplayName(), var1.size()), true);
        }
        return var4;
    }

    private static int resetScores(CommandListenerWrapper var0, Collection<String> var1) {
        ScoreboardServer var2 = var0.getServer().getScoreboard();
        for (String var4 : var1) {
            var2.resetPlayerScore(var4, null);
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.reset.all.single", var1.iterator().next()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.reset.all.multiple", var1.size()), true);
        }
        return var1.size();
    }

    private static int resetScore(CommandListenerWrapper var0, Collection<String> var1, ScoreboardObjective var2) {
        ScoreboardServer var3 = var0.getServer().getScoreboard();
        for (String var5 : var1) {
            var3.resetPlayerScore(var5, var2);
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.reset.specific.single", var2.getFormattedDisplayName(), var1.iterator().next()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.reset.specific.multiple", var2.getFormattedDisplayName(), var1.size()), true);
        }
        return var1.size();
    }

    private static int setScore(CommandListenerWrapper var0, Collection<String> var1, ScoreboardObjective var2, int var3) {
        ScoreboardServer var4 = var0.getServer().getScoreboard();
        for (String var6 : var1) {
            ScoreboardScore var7 = var4.getOrCreatePlayerScore(var6, var2);
            var7.setScore(var3);
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.set.success.single", var2.getFormattedDisplayName(), var1.iterator().next(), var3), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.set.success.multiple", var2.getFormattedDisplayName(), var1.size(), var3), true);
        }
        return var3 * var1.size();
    }

    private static int addScore(CommandListenerWrapper var0, Collection<String> var1, ScoreboardObjective var2, int var3) {
        ScoreboardServer var4 = var0.getServer().getScoreboard();
        int var5 = 0;
        for (String var7 : var1) {
            ScoreboardScore var8 = var4.getOrCreatePlayerScore(var7, var2);
            var8.setScore(var8.getScore() + var3);
            var5 += var8.getScore();
        }
        if (var1.size() == 1) {
            int var6 = var5;
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.add.success.single", var3, var2.getFormattedDisplayName(), var1.iterator().next(), var6), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.add.success.multiple", var3, var2.getFormattedDisplayName(), var1.size()), true);
        }
        return var5;
    }

    private static int removeScore(CommandListenerWrapper var0, Collection<String> var1, ScoreboardObjective var2, int var3) {
        ScoreboardServer var4 = var0.getServer().getScoreboard();
        int var5 = 0;
        for (String var7 : var1) {
            ScoreboardScore var8 = var4.getOrCreatePlayerScore(var7, var2);
            var8.setScore(var8.getScore() - var3);
            var5 += var8.getScore();
        }
        if (var1.size() == 1) {
            int var6 = var5;
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.remove.success.single", var3, var2.getFormattedDisplayName(), var1.iterator().next(), var6), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.remove.success.multiple", var3, var2.getFormattedDisplayName(), var1.size()), true);
        }
        return var5;
    }

    private static int listTrackedPlayers(CommandListenerWrapper var0) {
        Collection<String> var1 = var0.getServer().getScoreboard().getTrackedPlayers();
        if (var1.isEmpty()) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.list.empty"), false);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.list.success", var1.size(), ChatComponentUtils.formatList(var1)), false);
        }
        return var1.size();
    }

    private static int listTrackedPlayerScores(CommandListenerWrapper var0, String var1) {
        Map<ScoreboardObjective, ScoreboardScore> var2 = var0.getServer().getScoreboard().getPlayerScores(var1);
        if (var2.isEmpty()) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.list.entity.empty", var1), false);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.list.entity.success", var1, var2.size()), false);
            for (Map.Entry<ScoreboardObjective, ScoreboardScore> var4 : var2.entrySet()) {
                var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.players.list.entity.entry", ((ScoreboardObjective)var4.getKey()).getFormattedDisplayName(), ((ScoreboardScore)var4.getValue()).getScore()), false);
            }
        }
        return var2.size();
    }

    private static int clearDisplaySlot(CommandListenerWrapper var0, DisplaySlot var1) throws CommandSyntaxException {
        ScoreboardServer var2 = var0.getServer().getScoreboard();
        if (var2.getDisplayObjective(var1) == null) {
            throw ERROR_DISPLAY_SLOT_ALREADY_EMPTY.create();
        }
        ((Scoreboard)var2).setDisplayObjective(var1, null);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.objectives.display.cleared", var1.getSerializedName()), true);
        return 0;
    }

    private static int setDisplaySlot(CommandListenerWrapper var0, DisplaySlot var1, ScoreboardObjective var2) throws CommandSyntaxException {
        ScoreboardServer var3 = var0.getServer().getScoreboard();
        if (var3.getDisplayObjective(var1) == var2) {
            throw ERROR_DISPLAY_SLOT_ALREADY_SET.create();
        }
        ((Scoreboard)var3).setDisplayObjective(var1, var2);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.objectives.display.set", var1.getSerializedName(), var2.getDisplayName()), true);
        return 0;
    }

    private static int setDisplayName(CommandListenerWrapper var0, ScoreboardObjective var1, IChatBaseComponent var2) {
        if (!var1.getDisplayName().equals(var2)) {
            var1.setDisplayName(var2);
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.objectives.modify.displayname", var1.getName(), var1.getFormattedDisplayName()), true);
        }
        return 0;
    }

    private static int setRenderType(CommandListenerWrapper var0, ScoreboardObjective var1, IScoreboardCriteria.EnumScoreboardHealthDisplay var2) {
        if (var1.getRenderType() != var2) {
            var1.setRenderType(var2);
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.objectives.modify.rendertype", var1.getFormattedDisplayName()), true);
        }
        return 0;
    }

    private static int removeObjective(CommandListenerWrapper var0, ScoreboardObjective var1) {
        ScoreboardServer var2 = var0.getServer().getScoreboard();
        var2.removeObjective(var1);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.objectives.remove.success", var1.getFormattedDisplayName()), true);
        return var2.getObjectives().size();
    }

    private static int addObjective(CommandListenerWrapper var0, String var1, IScoreboardCriteria var2, IChatBaseComponent var3) throws CommandSyntaxException {
        ScoreboardServer var4 = var0.getServer().getScoreboard();
        if (var4.getObjective(var1) != null) {
            throw ERROR_OBJECTIVE_ALREADY_EXISTS.create();
        }
        var4.addObjective(var1, var2, var3, var2.getDefaultRenderType());
        ScoreboardObjective var5 = var4.getObjective(var1);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.objectives.add.success", var5.getFormattedDisplayName()), true);
        return var4.getObjectives().size();
    }

    private static int listObjectives(CommandListenerWrapper var0) {
        Collection<ScoreboardObjective> var1 = var0.getServer().getScoreboard().getObjectives();
        if (var1.isEmpty()) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.objectives.list.empty"), false);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.scoreboard.objectives.list.success", var1.size(), ChatComponentUtils.formatList(var1, ScoreboardObjective::getFormattedDisplayName)), false);
        }
        return var1.size();
    }
}

