/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.EntityHuman;

public class CommandList {
    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("list").executes(var0 -> CommandList.listPlayers((CommandListenerWrapper)var0.getSource()))).then(net.minecraft.commands.CommandDispatcher.literal("uuids").executes(var0 -> CommandList.listPlayersWithUuids((CommandListenerWrapper)var0.getSource()))));
    }

    private static int listPlayers(CommandListenerWrapper var0) {
        return CommandList.format(var0, EntityHuman::getDisplayName);
    }

    private static int listPlayersWithUuids(CommandListenerWrapper var02) {
        return CommandList.format(var02, var0 -> IChatBaseComponent.translatable("commands.list.nameAndId", var0.getName(), var0.getGameProfile().getId()));
    }

    private static int format(CommandListenerWrapper var0, Function<EntityPlayer, IChatBaseComponent> var1) {
        PlayerList var2 = var0.getServer().getPlayerList();
        List<EntityPlayer> var3 = var2.getPlayers();
        IChatBaseComponent var4 = ChatComponentUtils.formatList(var3, var1);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.list.players", var3.size(), var2.getMaxPlayers(), var4), false);
        return var3.size();
    }
}

