/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CustomFunction;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentNBTTag;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.commands.data.CommandDataAccessor;
import org.apache.commons.lang3.mutable.MutableObject;

public class CommandFunction {
    private static final DynamicCommandExceptionType ERROR_ARGUMENT_NOT_COMPOUND = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("commands.function.error.argument_not_compound", var0));
    public static final SuggestionProvider<CommandListenerWrapper> SUGGEST_FUNCTION = (var0, var1) -> {
        CustomFunctionData var2 = ((CommandListenerWrapper)var0.getSource()).getServer().getFunctions();
        ICompletionProvider.suggestResource(var2.getTagNames(), var1, "#");
        return ICompletionProvider.suggestResource(var2.getFunctionNames(), var1);
    };

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        LiteralArgumentBuilder<CommandListenerWrapper> var1 = net.minecraft.commands.CommandDispatcher.literal("with");
        for (CommandData.c var3 : CommandData.SOURCE_PROVIDERS) {
            var3.wrap((ArgumentBuilder<CommandListenerWrapper, ?>)var1, var12 -> var12.executes(var1 -> CommandFunction.runFunction((CommandListenerWrapper)var1.getSource(), ArgumentTag.getFunctions((CommandContext<CommandListenerWrapper>)var1, "name"), var3.access((CommandContext<CommandListenerWrapper>)var1).getData())).then(net.minecraft.commands.CommandDispatcher.argument("path", ArgumentNBTKey.nbtPath()).executes(var1 -> CommandFunction.runFunction((CommandListenerWrapper)var1.getSource(), ArgumentTag.getFunctions((CommandContext<CommandListenerWrapper>)var1, "name"), CommandFunction.getArgumentTag(ArgumentNBTKey.getPath((CommandContext<CommandListenerWrapper>)var1, "path"), var3.access((CommandContext<CommandListenerWrapper>)var1))))));
        }
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("function").requires(var0 -> var0.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("name", ArgumentTag.functions()).suggests(SUGGEST_FUNCTION).executes(var0 -> CommandFunction.runFunction((CommandListenerWrapper)var0.getSource(), ArgumentTag.getFunctions((CommandContext<CommandListenerWrapper>)var0, "name"), null))).then(net.minecraft.commands.CommandDispatcher.argument("arguments", ArgumentNBTTag.compoundTag()).executes(var0 -> CommandFunction.runFunction((CommandListenerWrapper)var0.getSource(), ArgumentTag.getFunctions((CommandContext<CommandListenerWrapper>)var0, "name"), ArgumentNBTTag.getCompoundTag(var0, "arguments"))))).then(var1)));
    }

    private static NBTTagCompound getArgumentTag(ArgumentNBTKey.g var0, CommandDataAccessor var1) throws CommandSyntaxException {
        NBTBase var2 = CommandData.getSingleTag(var0, var1);
        if (var2 instanceof NBTTagCompound) {
            NBTTagCompound var3 = (NBTTagCompound)var2;
            return var3;
        }
        throw ERROR_ARGUMENT_NOT_COMPOUND.create((Object)var2.getType().getName());
    }

    private static int runFunction(CommandListenerWrapper var0, Collection<CustomFunction> var1, @Nullable NBTTagCompound var2) {
        int var3 = 0;
        boolean var4 = false;
        boolean var5 = false;
        for (CustomFunction var7 : var1) {
            try {
                a var8 = CommandFunction.runFunction(var0, var7, var2);
                var3 += var8.value();
                var4 |= var8.isReturn();
                var5 = true;
            }
            catch (FunctionInstantiationException var8) {
                var0.sendFailure(var8.messageComponent());
            }
        }
        if (var5) {
            int var6 = var3;
            if (var1.size() == 1) {
                if (var4) {
                    var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.function.success.single.result", var6, ((CustomFunction)var1.iterator().next()).getId()), true);
                } else {
                    var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.function.success.single", var6, ((CustomFunction)var1.iterator().next()).getId()), true);
                }
            } else if (var4) {
                var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.function.success.multiple.result", var1.size()), true);
            } else {
                var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.function.success.multiple", var6, var1.size()), true);
            }
        }
        return var3;
    }

    public static a runFunction(CommandListenerWrapper var0, CustomFunction var12, @Nullable NBTTagCompound var2) throws FunctionInstantiationException {
        MutableObject var3 = new MutableObject();
        int var4 = var0.getServer().getFunctions().execute(var12, var0.withSuppressedOutput().withMaximumPermission(2).withReturnValueConsumer(var1 -> var3.setValue((Object)new a(var1, true))), null, var2);
        a var5 = (a)var3.getValue();
        if (var5 != null) {
            return var5;
        }
        return new a(var4, false);
    }

    public record a(int value, boolean isReturn) {
    }
}

