/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.EnumDifficulty;

public class CommandDifficulty {
    private static final DynamicCommandExceptionType ERROR_ALREADY_DIFFICULT = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("commands.difficulty.failure", var0));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        LiteralArgumentBuilder<CommandListenerWrapper> var12 = net.minecraft.commands.CommandDispatcher.literal("difficulty");
        for (EnumDifficulty var5 : EnumDifficulty.values()) {
            var12.then(net.minecraft.commands.CommandDispatcher.literal(var5.getKey()).executes(var1 -> CommandDifficulty.setDifficulty((CommandListenerWrapper)var1.getSource(), var5)));
        }
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)var12.requires(var0 -> var0.hasPermission(2))).executes(var0 -> {
            EnumDifficulty var1 = ((CommandListenerWrapper)var0.getSource()).getLevel().getDifficulty();
            ((CommandListenerWrapper)var0.getSource()).sendSuccess(() -> IChatBaseComponent.translatable("commands.difficulty.query", var1.getDisplayName()), false);
            return var1.getId();
        }));
    }

    public static int setDifficulty(CommandListenerWrapper var0, EnumDifficulty var1) throws CommandSyntaxException {
        MinecraftServer var2 = var0.getServer();
        if (var2.getWorldData().getDifficulty() == var1) {
            throw ERROR_ALREADY_DIFFICULT.create((Object)var1.getKey());
        }
        var2.setDifficulty(var1, true);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.difficulty.success", var1.getDisplayName()), true);
        return 0;
    }
}

