/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraft.CrashReport;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.EULA;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.level.progress.WorldLoadListenerLogger;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.repository.ResourcePackSourceVanilla;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import org.slf4j.Logger;

public class Main {
    private static final Logger LOGGER = LogUtils.getLogger();

    @DontObfuscate
    public static void main(String[] var0) {
        SharedConstants.tryDetectVersion();
        OptionParser var1 = new OptionParser();
        OptionSpecBuilder var2 = var1.accepts("nogui");
        OptionSpecBuilder var3 = var1.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder var4 = var1.accepts("demo");
        OptionSpecBuilder var5 = var1.accepts("bonusChest");
        OptionSpecBuilder var6 = var1.accepts("forceUpgrade");
        OptionSpecBuilder var7 = var1.accepts("eraseCache");
        OptionSpecBuilder var8 = var1.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec var9 = var1.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec var10 = var1.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec var11 = var1.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec var12 = var1.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec var13 = var1.accepts("serverId").withRequiredArg();
        OptionSpecBuilder var14 = var1.accepts("jfrProfile");
        ArgumentAcceptingOptionSpec var15 = var1.accepts("pidFile").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        NonOptionArgumentSpec var16 = var1.nonOptions();
        try {
            WorldStem var31;
            Object var32;
            boolean var29;
            OptionSet var17 = var1.parse(var0);
            if (var17.has((OptionSpec)var9)) {
                var1.printHelpOn((OutputStream)System.err);
                return;
            }
            Path var18 = (Path)var17.valueOf((OptionSpec)var15);
            if (var18 != null) {
                Main.writePidFile(var18);
            }
            CrashReport.preload();
            if (var17.has((OptionSpec)var14)) {
                JvmProfiler.INSTANCE.start(Environment.SERVER);
            }
            DispenserRegistry.bootStrap();
            DispenserRegistry.validate();
            SystemUtils.startTimerHackThread();
            Path var19 = Paths.get("server.properties", new String[0]);
            DedicatedServerSettings var20 = new DedicatedServerSettings(var19);
            var20.forceSave();
            Path var21 = Paths.get("eula.txt", new String[0]);
            EULA var22 = new EULA(var21);
            if (var17.has((OptionSpec)var3)) {
                LOGGER.info("Initialized '{}' and '{}'", (Object)var19.toAbsolutePath(), (Object)var21.toAbsolutePath());
                return;
            }
            if (!var22.hasAgreedToEULA()) {
                LOGGER.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File var23 = new File((String)var17.valueOf((OptionSpec)var10));
            Services var24 = Services.create(new YggdrasilAuthenticationService(Proxy.NO_PROXY), var23);
            String var25 = Optional.ofNullable((String)var17.valueOf((OptionSpec)var11)).orElse(var20.getProperties().levelName);
            Convertable var26 = Convertable.createDefault(var23.toPath());
            Convertable.ConversionSession var27 = var26.validateAndCreateAccess(var25);
            WorldInfo var28 = var27.getSummary();
            if (var28 != null) {
                if (var28.requiresManualConversion()) {
                    LOGGER.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!var28.isCompatible()) {
                    LOGGER.info("This world was created by an incompatible version.");
                    return;
                }
            }
            if (var29 = var17.has((OptionSpec)var8)) {
                LOGGER.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            ResourcePackRepository var30 = ResourcePackSourceVanilla.createPackRepository(var27);
            try {
                var32 = Main.loadOrCreateConfig(var20.getProperties(), var27, var29, var30);
                var31 = (WorldStem)SystemUtils.blockUntilDone(arg_0 -> Main.a((WorldLoader.c)var32, var27, var17, (OptionSpec)var4, var20, (OptionSpec)var5, arg_0)).get();
            }
            catch (Exception var322) {
                LOGGER.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)var322);
                return;
            }
            var32 = var31.registries().compositeAccess();
            if (var17.has((OptionSpec)var6)) {
                Main.forceUpgrade(var27, DataConverterRegistry.getDataFixer(), var17.has((OptionSpec)var7), () -> true, var32.registryOrThrow(Registries.LEVEL_STEM));
            }
            SaveData var33 = var31.worldData();
            var27.saveDataTag((IRegistryCustom)var32, var33);
            final DedicatedServer var34 = MinecraftServer.spin(arg_0 -> Main.a(var27, var30, var31, var20, var24, var17, (OptionSpec)var12, (OptionSpec)var4, (OptionSpec)var13, (OptionSpec)var2, (OptionSpec)var16, arg_0));
            Thread var35 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    var34.halt(true);
                }
            };
            var35.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
            Runtime.getRuntime().addShutdownHook(var35);
        }
        catch (Exception var17) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)var17);
        }
    }

    private static void writePidFile(Path var0) {
        try {
            long var1 = ProcessHandle.current().pid();
            Files.writeString(var0, (CharSequence)Long.toString(var1), new OpenOption[0]);
        }
        catch (IOException var1) {
            throw new UncheckedIOException(var1);
        }
    }

    private static WorldLoader.c loadOrCreateConfig(DedicatedServerProperties var0, Convertable.ConversionSession var1, boolean var2, ResourcePackRepository var3) {
        WorldDataConfiguration var5;
        boolean var6;
        WorldDataConfiguration var4 = var1.getDataConfiguration();
        if (var4 != null) {
            var6 = false;
            var5 = var4;
        } else {
            var6 = true;
            var5 = new WorldDataConfiguration(var0.initialDataPackConfiguration, FeatureFlags.DEFAULT_FLAGS);
        }
        WorldLoader.d var7 = new WorldLoader.d(var3, var5, var2, var6);
        return new WorldLoader.c(var7, CommandDispatcher.ServerType.DEDICATED, var0.functionPermissionLevel);
    }

    public static void forceUpgrade(Convertable.ConversionSession var0, DataFixer var1, boolean var2, BooleanSupplier var3, IRegistry<WorldDimension> var4) {
        LOGGER.info("Forcing world upgrade!");
        WorldUpgrader var5 = new WorldUpgrader(var0, var1, var4, var2);
        IChatBaseComponent var6 = null;
        while (!var5.isFinished()) {
            int var8;
            IChatBaseComponent var7 = var5.getStatus();
            if (var6 != var7) {
                var6 = var7;
                LOGGER.info(var5.getStatus().getString());
            }
            if ((var8 = var5.getTotalChunks()) > 0) {
                int var9 = var5.getConverted() + var5.getSkipped();
                LOGGER.info("{}% completed ({} / {} chunks)...", new Object[]{MathHelper.floor((float)var9 / (float)var8 * 100.0f), var9, var8});
            }
            if (!var3.getAsBoolean()) {
                var5.cancel();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ DedicatedServer a(Convertable.ConversionSession var0, ResourcePackRepository var1, WorldStem var2, DedicatedServerSettings var3, Services var4, OptionSet var5, OptionSpec var6, OptionSpec var7, OptionSpec var8, OptionSpec var9, OptionSpec var10, Thread var11) {
        boolean var13;
        DedicatedServer var12 = new DedicatedServer(var11, var0, var1, var2, var3, DataConverterRegistry.getDataFixer(), var4, WorldLoadListenerLogger::new);
        var12.setPort((Integer)var5.valueOf(var6));
        var12.setDemo(var5.has(var7));
        var12.setId((String)var5.valueOf(var8));
        boolean bl = var13 = !var5.has(var9) && !var5.valuesOf(var10).contains("nogui");
        if (var13 && !GraphicsEnvironment.isHeadless()) {
            var12.showGui();
        }
        return var12;
    }

    private static /* synthetic */ CompletableFuture a(WorldLoader.c var0, Convertable.ConversionSession var1, OptionSet var2, OptionSpec var3, DedicatedServerSettings var4, OptionSpec var52, Executor var6) {
        return WorldLoader.load(var0, var5 -> {
            Object var12;
            WorldDimensions var11;
            WorldOptions var10;
            WorldSettings var9;
            IRegistry<WorldDimension> var6 = var5.datapackDimensions().registryOrThrow(Registries.LEVEL_STEM);
            RegistryOps<NBTBase> var7 = RegistryOps.create(DynamicOpsNBT.INSTANCE, var5.datapackWorldgen());
            Pair<SaveData, WorldDimensions.b> var8 = var1.getDataTag(var7, var5.dataConfiguration(), var6, var5.datapackWorldgen().allRegistriesLifecycle());
            if (var8 != null) {
                return new WorldLoader.b<SaveData>((SaveData)var8.getFirst(), ((WorldDimensions.b)var8.getSecond()).dimensionsRegistryAccess());
            }
            if (var2.has(var3)) {
                var9 = MinecraftServer.DEMO_SETTINGS;
                var10 = WorldOptions.DEMO_OPTIONS;
                var11 = WorldPresets.createNormalWorldDimensions(var5.datapackWorldgen());
            } else {
                var12 = var4.getProperties();
                var9 = new WorldSettings(((DedicatedServerProperties)var12).levelName, ((DedicatedServerProperties)var12).gamemode, ((DedicatedServerProperties)var12).hardcore, ((DedicatedServerProperties)var12).difficulty, false, new GameRules(), var5.dataConfiguration());
                var10 = var2.has(var52) ? ((DedicatedServerProperties)var12).worldOptions.withBonusChest(true) : ((DedicatedServerProperties)var12).worldOptions;
                var11 = ((DedicatedServerProperties)var12).createDimensions(var5.datapackWorldgen());
            }
            var12 = var11.bake(var6);
            Lifecycle var13 = ((WorldDimensions.b)var12).lifecycle().add(var5.datapackWorldgen().allRegistriesLifecycle());
            return new WorldLoader.b<WorldDataServer>(new WorldDataServer(var9, var10, ((WorldDimensions.b)var12).specialWorldProperty(), var13), ((WorldDimensions.b)var12).dimensionsRegistryAccess());
        }, WorldStem::new, SystemUtils.backgroundExecutor(), var6);
    }
}

