/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.MapMaker;
import com.mojang.serialization.Codec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;

public class ResourceKey<T> {
    private static final ConcurrentMap<a, ResourceKey<?>> VALUES = new MapMaker().weakValues().makeMap();
    private final MinecraftKey registryName;
    private final MinecraftKey location;

    public static <T> Codec<ResourceKey<T>> codec(ResourceKey<? extends IRegistry<T>> var0) {
        return MinecraftKey.CODEC.xmap(var1 -> ResourceKey.create(var0, var1), ResourceKey::location);
    }

    public static <T> ResourceKey<T> create(ResourceKey<? extends IRegistry<T>> var0, MinecraftKey var1) {
        return ResourceKey.create(var0.location, var1);
    }

    public static <T> ResourceKey<IRegistry<T>> createRegistryKey(MinecraftKey var0) {
        return ResourceKey.create(BuiltInRegistries.ROOT_REGISTRY_NAME, var0);
    }

    private static <T> ResourceKey<T> create(MinecraftKey var02, MinecraftKey var1) {
        return VALUES.computeIfAbsent(new a(var02, var1), var0 -> new ResourceKey(var0.registry, var0.location));
    }

    private ResourceKey(MinecraftKey var0, MinecraftKey var1) {
        this.registryName = var0;
        this.location = var1;
    }

    public String toString() {
        return "ResourceKey[" + this.registryName + " / " + this.location + "]";
    }

    public boolean isFor(ResourceKey<? extends IRegistry<?>> var0) {
        return this.registryName.equals(var0.location());
    }

    public <E> Optional<ResourceKey<E>> cast(ResourceKey<? extends IRegistry<E>> var0) {
        return this.isFor(var0) ? Optional.of(this) : Optional.empty();
    }

    public MinecraftKey location() {
        return this.location;
    }

    public MinecraftKey registry() {
        return this.registryName;
    }

    static final class a
    extends Record {
        final MinecraftKey registry;
        final MinecraftKey location;

        a(MinecraftKey var0, MinecraftKey var1) {
            this.registry = var0;
            this.location = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "registry;location", "registry", "location"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "registry;location", "registry", "location"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "registry;location", "registry", "location"}, this, var0);
        }

        public MinecraftKey registry() {
            return this.registry;
        }

        public MinecraftKey location() {
            return this.location;
        }
    }
}

