/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.slf4j.Logger;

public class RegistryDataLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final List<b<?>> WORLDGEN_REGISTRIES = List.of(new b<DimensionManager>(Registries.DIMENSION_TYPE, DimensionManager.DIRECT_CODEC), new b<BiomeBase>(Registries.BIOME, BiomeBase.DIRECT_CODEC), new b<ChatMessageType>(Registries.CHAT_TYPE, ChatMessageType.CODEC), new b(Registries.CONFIGURED_CARVER, WorldGenCarverWrapper.DIRECT_CODEC), new b(Registries.CONFIGURED_FEATURE, WorldGenFeatureConfigured.DIRECT_CODEC), new b<PlacedFeature>(Registries.PLACED_FEATURE, PlacedFeature.DIRECT_CODEC), new b<Structure>(Registries.STRUCTURE, Structure.DIRECT_CODEC), new b<StructureSet>(Registries.STRUCTURE_SET, StructureSet.DIRECT_CODEC), new b<ProcessorList>(Registries.PROCESSOR_LIST, DefinedStructureStructureProcessorType.DIRECT_CODEC), new b<WorldGenFeatureDefinedStructurePoolTemplate>(Registries.TEMPLATE_POOL, WorldGenFeatureDefinedStructurePoolTemplate.DIRECT_CODEC), new b<GeneratorSettingBase>(Registries.NOISE_SETTINGS, GeneratorSettingBase.DIRECT_CODEC), new b<NoiseGeneratorNormal.a>(Registries.NOISE, NoiseGeneratorNormal.a.DIRECT_CODEC), new b<DensityFunction>(Registries.DENSITY_FUNCTION, DensityFunction.DIRECT_CODEC), new b<WorldPreset>(Registries.WORLD_PRESET, WorldPreset.DIRECT_CODEC), new b<FlatLevelGeneratorPreset>(Registries.FLAT_LEVEL_GENERATOR_PRESET, FlatLevelGeneratorPreset.DIRECT_CODEC), new b<TrimPattern>(Registries.TRIM_PATTERN, TrimPattern.DIRECT_CODEC), new b<TrimMaterial>(Registries.TRIM_MATERIAL, TrimMaterial.DIRECT_CODEC), new b<DamageType>(Registries.DAMAGE_TYPE, DamageType.CODEC), new b<MultiNoiseBiomeSourceParameterList>(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST, MultiNoiseBiomeSourceParameterList.DIRECT_CODEC));
    public static final List<b<?>> DIMENSION_REGISTRIES = List.of(new b<WorldDimension>(Registries.LEVEL_STEM, WorldDimension.CODEC));

    public static IRegistryCustom.Dimension load(IResourceManager var0, IRegistryCustom var12, List<b<?>> var22) {
        HashMap var3 = new HashMap();
        List<Pair<IRegistryWritable<?>, a>> var4 = var22.stream().map(var1 -> var1.create(Lifecycle.stable(), var3)).toList();
        RegistryOps.b var5 = RegistryDataLoader.createContext(var12, var4);
        var4.forEach(var2 -> ((a)var2.getSecond()).load(var0, var5));
        var4.forEach(var1 -> {
            IRegistry var2 = (IRegistry)var1.getFirst();
            try {
                var2.freeze();
            }
            catch (Exception var3) {
                var3.put(var2.key(), var3);
            }
        });
        if (!var3.isEmpty()) {
            RegistryDataLoader.logErrors(var3);
            throw new IllegalStateException("Failed to load registries due to above errors");
        }
        return new IRegistryCustom.c(var4.stream().map(Pair::getFirst).toList()).freeze();
    }

    private static RegistryOps.b createContext(IRegistryCustom var0, List<Pair<IRegistryWritable<?>, a>> var12) {
        final HashMap var2 = new HashMap();
        var0.registries().forEach(var1 -> var2.put(var1.key(), RegistryDataLoader.createInfoForContextRegistry(var1.value())));
        var12.forEach(var1 -> var2.put(((IRegistryWritable)var1.getFirst()).key(), RegistryDataLoader.createInfoForNewRegistry((IRegistryWritable)var1.getFirst())));
        return new RegistryOps.b(){

            @Override
            public <T> Optional<RegistryOps.a<T>> lookup(ResourceKey<? extends IRegistry<? extends T>> var0) {
                return Optional.ofNullable((RegistryOps.a)var2.get(var0));
            }
        };
    }

    private static <T> RegistryOps.a<T> createInfoForNewRegistry(IRegistryWritable<T> var0) {
        return new RegistryOps.a(var0.asLookup(), var0.createRegistrationLookup(), var0.registryLifecycle());
    }

    private static <T> RegistryOps.a<T> createInfoForContextRegistry(IRegistry<T> var0) {
        return new RegistryOps.a<T>(var0.asLookup(), var0.asTagAddingLookup(), var0.registryLifecycle());
    }

    private static void logErrors(Map<ResourceKey<?>, Exception> var02) {
        StringWriter var1 = new StringWriter();
        PrintWriter var2 = new PrintWriter(var1);
        Map<MinecraftKey, Map<MinecraftKey, Exception>> var3 = var02.entrySet().stream().collect(Collectors.groupingBy(var0 -> ((ResourceKey)var0.getKey()).registry(), Collectors.toMap(var0 -> ((ResourceKey)var0.getKey()).location(), Map.Entry::getValue)));
        var3.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(var12 -> {
            var2.printf("> Errors in registry %s:%n", var12.getKey());
            ((Map)var12.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(var1 -> {
                var2.printf(">> Errors in element %s:%n", var1.getKey());
                ((Exception)var1.getValue()).printStackTrace(var2);
            });
        });
        var2.flush();
        LOGGER.error("Registry loading errors:\n{}", (Object)var1);
    }

    private static String registryDirPath(MinecraftKey var0) {
        return var0.getPath();
    }

    static <E> void loadRegistryContents(RegistryOps.b var02, IResourceManager var1, ResourceKey<? extends IRegistry<E>> var2, IRegistryWritable<E> var3, Decoder<E> var4, Map<ResourceKey<?>, Exception> var5) {
        String var6 = RegistryDataLoader.registryDirPath(var2.location());
        FileToIdConverter var7 = FileToIdConverter.json(var6);
        RegistryOps var8 = RegistryOps.create(JsonOps.INSTANCE, var02);
        for (Map.Entry<MinecraftKey, IResource> var10 : var7.listMatchingResources(var1).entrySet()) {
            MinecraftKey var11 = var10.getKey();
            ResourceKey var12 = ResourceKey.create(var2, var7.fileToId(var11));
            IResource var13 = var10.getValue();
            try {
                BufferedReader var14 = var13.openAsReader();
                try {
                    JsonElement var15 = JsonParser.parseReader((Reader)var14);
                    DataResult var16 = var4.parse(var8, (Object)var15);
                    Object var17 = var16.getOrThrow(false, var0 -> {});
                    var3.register(var12, var17, var13.isBuiltin() ? Lifecycle.stable() : var16.lifecycle());
                }
                finally {
                    if (var14 == null) continue;
                    ((Reader)var14).close();
                }
            }
            catch (Exception var14) {
                var5.put(var12, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse %s from pack %s", var11, var13.sourcePackId()), var14));
            }
        }
    }

    static interface a {
        public void load(IResourceManager var1, RegistryOps.b var2);
    }

    public record b<T>(ResourceKey<? extends IRegistry<T>> key, Codec<T> elementCodec) {
        Pair<IRegistryWritable<?>, a> create(Lifecycle var0, Map<ResourceKey<?>, Exception> var1) {
            RegistryMaterials var22 = new RegistryMaterials(this.key, var0);
            a var32 = (var2, var3) -> RegistryDataLoader.loadRegistryContents(var3, var2, this.key, var22, this.elementCodec, var1);
            return Pair.of(var22, (Object)var32);
        }
    }
}

