/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.ScoreboardServer;

public class PacketPlayOutScoreboardScore
implements Packet<PacketListenerPlayOut> {
    private final String owner;
    @Nullable
    private final String objectiveName;
    private final int score;
    private final ScoreboardServer.Action method;

    public PacketPlayOutScoreboardScore(ScoreboardServer.Action var0, @Nullable String var1, String var2, int var3) {
        if (var0 != ScoreboardServer.Action.REMOVE && var1 == null) {
            throw new IllegalArgumentException("Need an objective name");
        }
        this.owner = var2;
        this.objectiveName = var1;
        this.score = var3;
        this.method = var0;
    }

    public PacketPlayOutScoreboardScore(PacketDataSerializer var0) {
        this.owner = var0.readUtf();
        this.method = var0.readEnum(ScoreboardServer.Action.class);
        String var1 = var0.readUtf();
        this.objectiveName = Objects.equals(var1, "") ? null : var1;
        this.score = this.method != ScoreboardServer.Action.REMOVE ? var0.readVarInt() : 0;
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeUtf(this.owner);
        var0.writeEnum(this.method);
        var0.writeUtf(this.objectiveName == null ? "" : this.objectiveName);
        if (this.method != ScoreboardServer.Action.REMOVE) {
            var0.writeVarInt(this.score);
        }
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleSetScore(this);
    }

    public String getOwner() {
        return this.owner;
    }

    @Nullable
    public String getObjectiveName() {
        return this.objectiveName;
    }

    public int getScore() {
        return this.score;
    }

    public ScoreboardServer.Action getMethod() {
        return this.method;
    }
}

