/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public class PacketPlayOutRecipeUpdate
implements Packet<PacketListenerPlayOut> {
    private final List<RecipeHolder<?>> recipes;

    public PacketPlayOutRecipeUpdate(Collection<RecipeHolder<?>> var0) {
        this.recipes = Lists.newArrayList(var0);
    }

    public PacketPlayOutRecipeUpdate(PacketDataSerializer var0) {
        this.recipes = var0.readList(PacketPlayOutRecipeUpdate::fromNetwork);
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeCollection(this.recipes, PacketPlayOutRecipeUpdate::toNetwork);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleUpdateRecipes(this);
    }

    public List<RecipeHolder<?>> getRecipes() {
        return this.recipes;
    }

    private static RecipeHolder<?> fromNetwork(PacketDataSerializer var0) {
        MinecraftKey var1 = var0.readResourceLocation();
        MinecraftKey var2 = var0.readResourceLocation();
        Object var3 = BuiltInRegistries.RECIPE_SERIALIZER.getOptional(var1).orElseThrow(() -> new IllegalArgumentException("Unknown recipe serializer " + var1)).fromNetwork(var0);
        return new RecipeHolder(var2, var3);
    }

    public static <T extends IRecipe<?>> void toNetwork(PacketDataSerializer var0, RecipeHolder<?> var1) {
        var0.writeResourceLocation(BuiltInRegistries.RECIPE_SERIALIZER.getKey(var1.value().getSerializer()));
        var0.writeResourceLocation(var1.id());
        var1.value().getSerializer().toNetwork(var0, var1.value());
    }
}

