/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.BitSet;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class PacketPlayOutLightUpdate
implements Packet<PacketListenerPlayOut> {
    private final int x;
    private final int z;
    private final ClientboundLightUpdatePacketData lightData;

    public PacketPlayOutLightUpdate(ChunkCoordIntPair var0, LevelLightEngine var1, @Nullable BitSet var2, @Nullable BitSet var3) {
        this.x = var0.x;
        this.z = var0.z;
        this.lightData = new ClientboundLightUpdatePacketData(var0, var1, var2, var3);
    }

    public PacketPlayOutLightUpdate(PacketDataSerializer var0) {
        this.x = var0.readVarInt();
        this.z = var0.readVarInt();
        this.lightData = new ClientboundLightUpdatePacketData(var0, this.x, this.z);
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.x);
        var0.writeVarInt(this.z);
        this.lightData.write(var0);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleLightUpdatePacket(this);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public ClientboundLightUpdatePacketData getLightData() {
        return this.lightData;
    }
}

