/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.block.Block;

public class PacketPlayOutBlockAction
implements Packet<PacketListenerPlayOut> {
    private final BlockPosition pos;
    private final int b0;
    private final int b1;
    private final Block block;

    public PacketPlayOutBlockAction(BlockPosition var0, Block var1, int var2, int var3) {
        this.pos = var0;
        this.block = var1;
        this.b0 = var2;
        this.b1 = var3;
    }

    public PacketPlayOutBlockAction(PacketDataSerializer var0) {
        this.pos = var0.readBlockPos();
        this.b0 = var0.readUnsignedByte();
        this.b1 = var0.readUnsignedByte();
        this.block = var0.readById(BuiltInRegistries.BLOCK);
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeBlockPos(this.pos);
        var0.writeByte(this.b0);
        var0.writeByte(this.b1);
        var0.writeId(BuiltInRegistries.BLOCK, this.block);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleBlockEvent(this);
    }

    public BlockPosition getPos() {
        return this.pos;
    }

    public int getB0() {
        return this.b0;
    }

    public int getB1() {
        return this.b1;
    }

    public Block getBlock() {
        return this.block;
    }
}

