/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;

public class PacketPlayInUpdateSign
implements Packet<PacketListenerPlayIn> {
    private static final int MAX_STRING_LENGTH = 384;
    private final BlockPosition pos;
    private final String[] lines;
    private final boolean isFrontText;

    public PacketPlayInUpdateSign(BlockPosition var0, boolean var1, String var2, String var3, String var4, String var5) {
        this.pos = var0;
        this.isFrontText = var1;
        this.lines = new String[]{var2, var3, var4, var5};
    }

    public PacketPlayInUpdateSign(PacketDataSerializer var0) {
        this.pos = var0.readBlockPos();
        this.isFrontText = var0.readBoolean();
        this.lines = new String[4];
        for (int var1 = 0; var1 < 4; ++var1) {
            this.lines[var1] = var0.readUtf(384);
        }
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeBlockPos(this.pos);
        var0.writeBoolean(this.isFrontText);
        for (int var1 = 0; var1 < 4; ++var1) {
            var0.writeUtf(this.lines[var1]);
        }
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handleSignUpdate(this);
    }

    public BlockPosition getPos() {
        return this.pos;
    }

    public boolean isFrontText() {
        return this.isFrontText;
    }

    public String[] getLines() {
        return this.lines;
    }
}

