/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.BitSet;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class ClientboundLevelChunkWithLightPacket
implements Packet<PacketListenerPlayOut> {
    private final int x;
    private final int z;
    private final ClientboundLevelChunkPacketData chunkData;
    private final ClientboundLightUpdatePacketData lightData;

    public ClientboundLevelChunkWithLightPacket(Chunk var0, LevelLightEngine var1, @Nullable BitSet var2, @Nullable BitSet var3) {
        ChunkCoordIntPair var4 = var0.getPos();
        this.x = var4.x;
        this.z = var4.z;
        this.chunkData = new ClientboundLevelChunkPacketData(var0);
        this.lightData = new ClientboundLightUpdatePacketData(var4, var1, var2, var3);
    }

    public ClientboundLevelChunkWithLightPacket(PacketDataSerializer var0) {
        this.x = var0.readInt();
        this.z = var0.readInt();
        this.chunkData = new ClientboundLevelChunkPacketData(var0, this.x, this.z);
        this.lightData = new ClientboundLightUpdatePacketData(var0, this.x, this.z);
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeInt(this.x);
        var0.writeInt(this.z);
        this.chunkData.write(var0);
        this.lightData.write(var0);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleLevelChunkWithLight(this);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public ClientboundLevelChunkPacketData getChunkData() {
        return this.chunkData;
    }

    public ClientboundLightUpdatePacketData getLightData() {
        return this.lightData;
    }
}

