/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common;

import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;

public class ClientboundResourcePackPacket
implements Packet<ClientCommonPacketListener> {
    public static final int MAX_HASH_LENGTH = 40;
    private final String url;
    private final String hash;
    private final boolean required;
    @Nullable
    private final IChatBaseComponent prompt;

    public ClientboundResourcePackPacket(String var0, String var1, boolean var2, @Nullable IChatBaseComponent var3) {
        if (var1.length() > 40) {
            throw new IllegalArgumentException("Hash is too long (max 40, was " + var1.length() + ")");
        }
        this.url = var0;
        this.hash = var1;
        this.required = var2;
        this.prompt = var3;
    }

    public ClientboundResourcePackPacket(PacketDataSerializer var0) {
        this.url = var0.readUtf();
        this.hash = var0.readUtf(40);
        this.required = var0.readBoolean();
        this.prompt = (IChatBaseComponent)var0.readNullable(PacketDataSerializer::readComponent);
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeUtf(this.url);
        var0.writeUtf(this.hash);
        var0.writeBoolean(this.required);
        var0.writeNullable(this.prompt, PacketDataSerializer::writeComponent);
    }

    @Override
    public void handle(ClientCommonPacketListener var0) {
        var0.handleResourcePack(this);
    }

    public String getUrl() {
        return this.url;
    }

    public String getHash() {
        return this.hash;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Nullable
    public IChatBaseComponent getPrompt() {
        return this.prompt;
    }
}

