/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import com.mojang.logging.LogUtils;
import net.minecraft.ReportedException;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.thread.IAsyncTaskHandler;
import org.slf4j.Logger;

public class PlayerConnectionUtils {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <T extends PacketListener> void ensureRunningOnSameThread(Packet<T> var0, T var1, WorldServer var2) throws CancelledPacketHandleException {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, var1, var2.getServer());
    }

    public static <T extends PacketListener> void ensureRunningOnSameThread(Packet<T> var0, T var1, IAsyncTaskHandler<?> var2) throws CancelledPacketHandleException {
        if (!var2.isSameThread()) {
            var2.executeIfPossible(() -> {
                if (var1.shouldHandleMessage(var0)) {
                    try {
                        var0.handle(var1);
                    }
                    catch (Exception var2) {
                        ReportedException var3;
                        if (var2 instanceof ReportedException && (var3 = (ReportedException)var2).getCause() instanceof OutOfMemoryError || var1.shouldPropagateHandlingExceptions()) {
                            throw var2;
                        }
                        LOGGER.error("Failed to handle packet {}, suppressing error", (Object)var0, (Object)var2);
                    }
                } else {
                    LOGGER.debug("Ignoring packet due to disconnection: {}", (Object)var0);
                }
            });
            throw CancelledPacketHandleException.RUNNING_ON_DIFFERENT_THREAD;
        }
    }
}

