/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.Packet;

public interface BundlerInfo {
    public static final int BUNDLE_SIZE_LIMIT = 4096;
    public static final BundlerInfo EMPTY = new BundlerInfo(){

        @Override
        public void unbundlePacket(Packet<?> var0, Consumer<Packet<?>> var1) {
            var1.accept(var0);
        }

        @Override
        @Nullable
        public a startPacketBundling(Packet<?> var0) {
            return null;
        }
    };

    public static <T extends PacketListener, P extends BundlePacket<T>> BundlerInfo createForPacket(final Class<P> var0, final Function<Iterable<Packet<T>>, P> var1, final BundleDelimiterPacket<T> var2) {
        return new BundlerInfo(){

            @Override
            public void unbundlePacket(Packet<?> var02, Consumer<Packet<?>> var12) {
                if (var02.getClass() == var0) {
                    BundlePacket var22 = (BundlePacket)var02;
                    var12.accept(var2);
                    var22.subPackets().forEach(var12);
                    var12.accept(var2);
                } else {
                    var12.accept(var02);
                }
            }

            @Override
            @Nullable
            public a startPacketBundling(Packet<?> var02) {
                if (var02 == var2) {
                    return new a(){
                        private final List<Packet<T>> bundlePackets = new ArrayList();

                        @Override
                        @Nullable
                        public Packet<?> addPacket(Packet<?> var0) {
                            if (var0 == var2) {
                                return (Packet)var1.apply(this.bundlePackets);
                            }
                            Packet<?> var1 = var0;
                            if (this.bundlePackets.size() >= 4096) {
                                throw new IllegalStateException("Too many packets in a bundle");
                            }
                            this.bundlePackets.add(var1);
                            return null;
                        }
                    };
                }
                return null;
            }
        };
    }

    public void unbundlePacket(Packet<?> var1, Consumer<Packet<?>> var2);

    @Nullable
    public a startPacketBundling(Packet<?> var1);

    public static interface b {
        public BundlerInfo bundlerInfo();
    }

    public static interface a {
        @Nullable
        public Packet<?> addPacket(Packet<?> var1);
    }
}

