/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.TranslatableFormatException;
import net.minecraft.world.entity.Entity;

public class TranslatableContents
implements ComponentContents {
    public static final Object[] NO_ARGS = new Object[0];
    private static final IChatFormatted TEXT_PERCENT = IChatFormatted.of("%");
    private static final IChatFormatted TEXT_NULL = IChatFormatted.of("null");
    private final String key;
    @Nullable
    private final String fallback;
    private final Object[] args;
    @Nullable
    private LocaleLanguage decomposedWith;
    private List<IChatFormatted> decomposedParts = ImmutableList.of();
    private static final Pattern FORMAT_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public TranslatableContents(String var0, @Nullable String var1, Object[] var2) {
        this.key = var0;
        this.fallback = var1;
        this.args = var2;
    }

    private void decompose() {
        LocaleLanguage var0 = LocaleLanguage.getInstance();
        if (var0 == this.decomposedWith) {
            return;
        }
        this.decomposedWith = var0;
        String var1 = this.fallback != null ? var0.getOrDefault(this.key, this.fallback) : var0.getOrDefault(this.key);
        try {
            ImmutableList.Builder var2 = ImmutableList.builder();
            this.decomposeTemplate(var1, arg_0 -> ((ImmutableList.Builder)var2).add(arg_0));
            this.decomposedParts = var2.build();
        }
        catch (TranslatableFormatException var2) {
            this.decomposedParts = ImmutableList.of((Object)IChatFormatted.of(var1));
        }
    }

    private void decomposeTemplate(String var0, Consumer<IChatFormatted> var1) {
        Matcher var2 = FORMAT_PATTERN.matcher(var0);
        try {
            int var3 = 0;
            int var4 = 0;
            while (var2.find(var4)) {
                String var7;
                int var5 = var2.start();
                int var6 = var2.end();
                if (var5 > var4) {
                    var7 = var0.substring(var4, var5);
                    if (var7.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    var1.accept(IChatFormatted.of(var7));
                }
                var7 = var2.group(2);
                String var8 = var0.substring(var5, var6);
                if ("%".equals(var7) && "%%".equals(var8)) {
                    var1.accept(TEXT_PERCENT);
                } else if ("s".equals(var7)) {
                    String var9 = var2.group(1);
                    int var10 = var9 != null ? Integer.parseInt(var9) - 1 : var3++;
                    var1.accept(this.getArgument(var10));
                } else {
                    throw new TranslatableFormatException(this, "Unsupported format: '" + var8 + "'");
                }
                var4 = var6;
            }
            if (var4 < var0.length()) {
                String var5 = var0.substring(var4);
                if (var5.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                var1.accept(IChatFormatted.of(var5));
            }
        }
        catch (IllegalArgumentException var3) {
            throw new TranslatableFormatException(this, (Throwable)var3);
        }
    }

    private IChatFormatted getArgument(int var0) {
        if (var0 < 0 || var0 >= this.args.length) {
            throw new TranslatableFormatException(this, var0);
        }
        Object var1 = this.args[var0];
        if (var1 instanceof IChatBaseComponent) {
            return (IChatBaseComponent)var1;
        }
        return var1 == null ? TEXT_NULL : IChatFormatted.of(var1.toString());
    }

    @Override
    public <T> Optional<T> visit(IChatFormatted.b<T> var0, ChatModifier var1) {
        this.decompose();
        for (IChatFormatted var3 : this.decomposedParts) {
            Optional<T> var4 = var3.visit(var0, var1);
            if (!var4.isPresent()) continue;
            return var4;
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> visit(IChatFormatted.a<T> var0) {
        this.decompose();
        for (IChatFormatted var2 : this.decomposedParts) {
            Optional<T> var3 = var2.visit(var0);
            if (!var3.isPresent()) continue;
            return var3;
        }
        return Optional.empty();
    }

    @Override
    public IChatMutableComponent resolve(@Nullable CommandListenerWrapper var0, @Nullable Entity var1, int var2) throws CommandSyntaxException {
        Object[] var3 = new Object[this.args.length];
        for (int var4 = 0; var4 < var3.length; ++var4) {
            Object var5 = this.args[var4];
            var3[var4] = var5 instanceof IChatBaseComponent ? ChatComponentUtils.updateForEntity(var0, (IChatBaseComponent)var5, var1, var2) : var5;
        }
        return IChatMutableComponent.create(new TranslatableContents(this.key, this.fallback, var3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof TranslatableContents)) return false;
        TranslatableContents var1 = (TranslatableContents)var0;
        if (!Objects.equals(this.key, var1.key)) return false;
        if (!Objects.equals(this.fallback, var1.fallback)) return false;
        if (!Arrays.equals(this.args, var1.args)) return false;
        return true;
    }

    public int hashCode() {
        int var0 = Objects.hashCode(this.key);
        var0 = 31 * var0 + Objects.hashCode(this.fallback);
        var0 = 31 * var0 + Arrays.hashCode(this.args);
        return var0;
    }

    public String toString() {
        return "translation{key='" + this.key + "'" + (String)(this.fallback != null ? ", fallback='" + this.fallback + "'" : "") + ", args=" + Arrays.toString(this.args) + "}";
    }

    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getFallback() {
        return this.fallback;
    }

    public Object[] getArgs() {
        return this.args;
    }
}

