/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.io.IOException;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.ProtocolSwapHandler;
import net.minecraft.network.SkipEncodeException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.slf4j.Logger;

public class PacketEncoder
extends MessageToByteEncoder<Packet<?>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AttributeKey<EnumProtocol.a<?>> codecKey;

    public PacketEncoder(AttributeKey<EnumProtocol.a<?>> var0) {
        this.codecKey = var0;
    }

    protected void encode(ChannelHandlerContext var0, Packet<?> var1, ByteBuf var2) throws Exception {
        Attribute var3 = var0.channel().attr(this.codecKey);
        EnumProtocol.a var4 = (EnumProtocol.a)var3.get();
        if (var4 == null) {
            throw new RuntimeException("ConnectionProtocol unknown: " + var1);
        }
        int var5 = var4.packetId(var1);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(NetworkManager.PACKET_SENT_MARKER, "OUT: [{}:{}] {}", new Object[]{var4.protocol().id(), var5, var1.getClass().getName()});
        }
        if (var5 == -1) {
            throw new IOException("Can't serialize unregistered packet");
        }
        PacketDataSerializer var6 = new PacketDataSerializer(var2);
        var6.writeVarInt(var5);
        try {
            int var7 = var6.writerIndex();
            var1.write(var6);
            int var8 = var6.writerIndex() - var7;
            if (var8 > 0x800000) {
                throw new IllegalArgumentException("Packet too big (is " + var8 + ", should be less than 8388608): " + var1);
            }
            JvmProfiler.INSTANCE.onPacketSent(var4.protocol(), var5, var0.channel().remoteAddress(), var8);
        }
        catch (Throwable var7) {
            LOGGER.error("Error receiving packet {}", (Object)var5, (Object)var7);
            if (var1.isSkippable()) {
                throw new SkipEncodeException(var7);
            }
            throw var7;
        }
        finally {
            ProtocolSwapHandler.swapProtocolIfNeeded(var3, var1);
        }
    }

    protected /* synthetic */ void encode(ChannelHandlerContext channelHandlerContext, Object object, ByteBuf byteBuf) throws Exception {
        this.encode(channelHandlerContext, (Packet)object, byteBuf);
    }
}

