/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.Objects;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;

public class NBTTagString
implements NBTBase {
    private static final int SELF_SIZE_IN_BYTES = 36;
    public static final NBTTagType<NBTTagString> TYPE = new NBTTagType.b<NBTTagString>(){

        @Override
        public NBTTagString load(DataInput var0, NBTReadLimiter var1) throws IOException {
            return NBTTagString.valueOf(1.readAccounted(var0, var1));
        }

        @Override
        public StreamTagVisitor.b parse(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
            return var1.visit(1.readAccounted(var0, var2));
        }

        private static String readAccounted(DataInput var0, NBTReadLimiter var1) throws IOException {
            var1.accountBytes(36L);
            String var2 = var0.readUTF();
            var1.accountBytes(2L, var2.length());
            return var2;
        }

        @Override
        public void skip(DataInput var0, NBTReadLimiter var1) throws IOException {
            NBTTagString.skipString(var0);
        }

        @Override
        public String getName() {
            return "STRING";
        }

        @Override
        public String getPrettyName() {
            return "TAG_String";
        }

        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public /* synthetic */ NBTBase load(DataInput dataInput, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.load(dataInput, nBTReadLimiter);
        }
    };
    private static final NBTTagString EMPTY = new NBTTagString("");
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SINGLE_QUOTE = '\'';
    private static final char ESCAPE = '\\';
    private static final char NOT_SET = '\u0000';
    private final String data;

    public static void skipString(DataInput var0) throws IOException {
        var0.skipBytes(var0.readUnsignedShort());
    }

    private NBTTagString(String var0) {
        Objects.requireNonNull(var0, "Null string not allowed");
        this.data = var0;
    }

    public static NBTTagString valueOf(String var0) {
        if (var0.isEmpty()) {
            return EMPTY;
        }
        return new NBTTagString(var0);
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        try {
            var0.writeUTF(this.data);
        }
        catch (UTFDataFormatException var1) {
            SystemUtils.logAndPauseIfInIde("Failed to write NBT String", var1);
            var0.writeUTF("");
        }
    }

    @Override
    public int sizeInBytes() {
        return 36 + 2 * this.data.length();
    }

    @Override
    public byte getId() {
        return 8;
    }

    public NBTTagType<NBTTagString> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        return NBTBase.super.getAsString();
    }

    @Override
    public NBTTagString copy() {
        return this;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof NBTTagString && Objects.equals(this.data, ((NBTTagString)var0).data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public String getAsString() {
        return this.data;
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitString(this);
    }

    public static String quoteAndEscape(String var0) {
        StringBuilder var1 = new StringBuilder(" ");
        int var2 = 0;
        for (int var3 = 0; var3 < var0.length(); ++var3) {
            int var4 = var0.charAt(var3);
            if (var4 == 92) {
                var1.append('\\');
            } else if (var4 == 34 || var4 == 39) {
                if (var2 == 0) {
                    int n2 = var2 = var4 == 34 ? 39 : 34;
                }
                if (var2 == var4) {
                    var1.append('\\');
                }
            }
            var1.append((char)var4);
        }
        if (var2 == 0) {
            var2 = 34;
        }
        var1.setCharAt(0, (char)var2);
        var1.append((char)var2);
        return var1.toString();
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor var0) {
        return var0.visit(this.data);
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }
}

