/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.FastBufferedInputStream;

public class NBTCompressedStreamTools {
    public static NBTTagCompound readCompressed(File var0) throws IOException {
        try (FileInputStream var1 = new FileInputStream(var0);){
            NBTTagCompound nBTTagCompound = NBTCompressedStreamTools.readCompressed(var1);
            return nBTTagCompound;
        }
    }

    private static DataInputStream createDecompressorStream(InputStream var0) throws IOException {
        return new DataInputStream(new FastBufferedInputStream(new GZIPInputStream(var0)));
    }

    public static NBTTagCompound readCompressed(InputStream var0) throws IOException {
        try (DataInputStream var1 = NBTCompressedStreamTools.createDecompressorStream(var0);){
            NBTTagCompound nBTTagCompound = NBTCompressedStreamTools.read(var1, NBTReadLimiter.unlimitedHeap());
            return nBTTagCompound;
        }
    }

    public static void parseCompressed(File var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
        try (FileInputStream var3 = new FileInputStream(var0);){
            NBTCompressedStreamTools.parseCompressed(var3, var1, var2);
        }
    }

    public static void parseCompressed(InputStream var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
        try (DataInputStream var3 = NBTCompressedStreamTools.createDecompressorStream(var0);){
            NBTCompressedStreamTools.parse(var3, var1, var2);
        }
    }

    public static void writeCompressed(NBTTagCompound var0, File var1) throws IOException {
        try (FileOutputStream var2 = new FileOutputStream(var1);){
            NBTCompressedStreamTools.writeCompressed(var0, var2);
        }
    }

    public static void writeCompressed(NBTTagCompound var0, OutputStream var1) throws IOException {
        try (DataOutputStream var2 = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(var1)));){
            NBTCompressedStreamTools.write(var0, var2);
        }
    }

    public static void write(NBTTagCompound var0, File var1) throws IOException {
        try (FileOutputStream var2 = new FileOutputStream(var1);
             DataOutputStream var3 = new DataOutputStream(var2);){
            NBTCompressedStreamTools.write(var0, var3);
        }
    }

    @Nullable
    public static NBTTagCompound read(File var0) throws IOException {
        if (!var0.exists()) {
            return null;
        }
        try (FileInputStream var1 = new FileInputStream(var0);){
            NBTTagCompound nBTTagCompound;
            try (DataInputStream var2 = new DataInputStream(var1);){
                nBTTagCompound = NBTCompressedStreamTools.read(var2, NBTReadLimiter.unlimitedHeap());
            }
            return nBTTagCompound;
        }
    }

    public static NBTTagCompound read(DataInput var0) throws IOException {
        return NBTCompressedStreamTools.read(var0, NBTReadLimiter.unlimitedHeap());
    }

    public static NBTTagCompound read(DataInput var0, NBTReadLimiter var1) throws IOException {
        NBTBase var2 = NBTCompressedStreamTools.readUnnamedTag(var0, var1);
        if (var2 instanceof NBTTagCompound) {
            return (NBTTagCompound)var2;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void write(NBTTagCompound var0, DataOutput var1) throws IOException {
        NBTCompressedStreamTools.writeUnnamedTag(var0, var1);
    }

    public static void parse(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
        NBTTagType<?> var3 = NBTTagTypes.getType(var0.readByte());
        if (var3 == NBTTagEnd.TYPE) {
            if (var1.visitRootEntry(NBTTagEnd.TYPE) == StreamTagVisitor.b.CONTINUE) {
                var1.visitEnd();
            }
            return;
        }
        switch (var1.visitRootEntry(var3)) {
            case HALT: {
                break;
            }
            case BREAK: {
                NBTTagString.skipString(var0);
                var3.skip(var0, var2);
                break;
            }
            case CONTINUE: {
                NBTTagString.skipString(var0);
                var3.parse(var0, var1, var2);
            }
        }
    }

    public static NBTBase readAnyTag(DataInput var0, NBTReadLimiter var1) throws IOException {
        byte var2 = var0.readByte();
        if (var2 == 0) {
            return NBTTagEnd.INSTANCE;
        }
        return NBTCompressedStreamTools.readTagSafe(var0, var1, var2);
    }

    public static void writeAnyTag(NBTBase var0, DataOutput var1) throws IOException {
        var1.writeByte(var0.getId());
        if (var0.getId() == 0) {
            return;
        }
        var0.write(var1);
    }

    public static void writeUnnamedTag(NBTBase var0, DataOutput var1) throws IOException {
        var1.writeByte(var0.getId());
        if (var0.getId() == 0) {
            return;
        }
        var1.writeUTF("");
        var0.write(var1);
    }

    private static NBTBase readUnnamedTag(DataInput var0, NBTReadLimiter var1) throws IOException {
        byte var2 = var0.readByte();
        if (var2 == 0) {
            return NBTTagEnd.INSTANCE;
        }
        NBTTagString.skipString(var0);
        return NBTCompressedStreamTools.readTagSafe(var0, var1, var2);
    }

    private static NBTBase readTagSafe(DataInput var0, NBTReadLimiter var1, byte var2) {
        try {
            return NBTTagTypes.getType(var2).load(var0, var1);
        }
        catch (IOException var3) {
            CrashReport var4 = CrashReport.forThrowable(var3, "Loading NBT data");
            CrashReportSystemDetails var5 = var4.addCategory("NBT Tag");
            var5.setDetail("Tag type", var2);
            throw new ReportedException(var4);
        }
    }
}

