/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.network.chat.IChatBaseComponent;

public class MojangsonParser {
    public static final SimpleCommandExceptionType ERROR_TRAILING_DATA = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.nbt.trailing"));
    public static final SimpleCommandExceptionType ERROR_EXPECTED_KEY = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.nbt.expected.key"));
    public static final SimpleCommandExceptionType ERROR_EXPECTED_VALUE = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.nbt.expected.value"));
    public static final Dynamic2CommandExceptionType ERROR_INSERT_MIXED_LIST = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatable("argument.nbt.list.mixed", var0, var1));
    public static final Dynamic2CommandExceptionType ERROR_INSERT_MIXED_ARRAY = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatable("argument.nbt.array.mixed", var0, var1));
    public static final DynamicCommandExceptionType ERROR_INVALID_ARRAY = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("argument.nbt.array.invalid", var0));
    public static final char ELEMENT_SEPARATOR = ',';
    public static final char NAME_VALUE_SEPARATOR = ':';
    private static final char LIST_OPEN = '[';
    private static final char LIST_CLOSE = ']';
    private static final char STRUCT_CLOSE = '}';
    private static final char STRUCT_OPEN = '{';
    private static final Pattern DOUBLE_PATTERN_NOSUFFIX = Pattern.compile("[-+]?(?:[0-9]+[.]|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?", 2);
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final Pattern FLOAT_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?f", 2);
    private static final Pattern BYTE_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)b", 2);
    private static final Pattern LONG_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)l", 2);
    private static final Pattern SHORT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)s", 2);
    private static final Pattern INT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)");
    public static final Codec<NBTTagCompound> AS_CODEC = Codec.STRING.comapFlatMap(var0 -> {
        try {
            return DataResult.success((Object)new MojangsonParser(new StringReader(var0)).readSingleStruct(), (Lifecycle)Lifecycle.stable());
        }
        catch (CommandSyntaxException var1) {
            return DataResult.error(() -> ((CommandSyntaxException)var1).getMessage());
        }
    }, NBTTagCompound::toString);
    private final StringReader reader;

    public static NBTTagCompound parseTag(String var0) throws CommandSyntaxException {
        return new MojangsonParser(new StringReader(var0)).readSingleStruct();
    }

    @VisibleForTesting
    NBTTagCompound readSingleStruct() throws CommandSyntaxException {
        NBTTagCompound var0 = this.readStruct();
        this.reader.skipWhitespace();
        if (this.reader.canRead()) {
            throw ERROR_TRAILING_DATA.createWithContext((ImmutableStringReader)this.reader);
        }
        return var0;
    }

    public MojangsonParser(StringReader var0) {
        this.reader = var0;
    }

    protected String readKey() throws CommandSyntaxException {
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw ERROR_EXPECTED_KEY.createWithContext((ImmutableStringReader)this.reader);
        }
        return this.reader.readString();
    }

    protected NBTBase readTypedValue() throws CommandSyntaxException {
        this.reader.skipWhitespace();
        int var0 = this.reader.getCursor();
        if (StringReader.isQuotedStringStart((char)this.reader.peek())) {
            return NBTTagString.valueOf(this.reader.readQuotedString());
        }
        String var1 = this.reader.readUnquotedString();
        if (var1.isEmpty()) {
            this.reader.setCursor(var0);
            throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        return this.type(var1);
    }

    public NBTBase type(String var0) {
        try {
            if (FLOAT_PATTERN.matcher(var0).matches()) {
                return NBTTagFloat.valueOf(Float.parseFloat(var0.substring(0, var0.length() - 1)));
            }
            if (BYTE_PATTERN.matcher(var0).matches()) {
                return NBTTagByte.valueOf(Byte.parseByte(var0.substring(0, var0.length() - 1)));
            }
            if (LONG_PATTERN.matcher(var0).matches()) {
                return NBTTagLong.valueOf(Long.parseLong(var0.substring(0, var0.length() - 1)));
            }
            if (SHORT_PATTERN.matcher(var0).matches()) {
                return NBTTagShort.valueOf(Short.parseShort(var0.substring(0, var0.length() - 1)));
            }
            if (INT_PATTERN.matcher(var0).matches()) {
                return NBTTagInt.valueOf(Integer.parseInt(var0));
            }
            if (DOUBLE_PATTERN.matcher(var0).matches()) {
                return NBTTagDouble.valueOf(Double.parseDouble(var0.substring(0, var0.length() - 1)));
            }
            if (DOUBLE_PATTERN_NOSUFFIX.matcher(var0).matches()) {
                return NBTTagDouble.valueOf(Double.parseDouble(var0));
            }
            if ("true".equalsIgnoreCase(var0)) {
                return NBTTagByte.ONE;
            }
            if ("false".equalsIgnoreCase(var0)) {
                return NBTTagByte.ZERO;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return NBTTagString.valueOf(var0);
    }

    public NBTBase readValue() throws CommandSyntaxException {
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        char var0 = this.reader.peek();
        if (var0 == '{') {
            return this.readStruct();
        }
        if (var0 == '[') {
            return this.readList();
        }
        return this.readTypedValue();
    }

    protected NBTBase readList() throws CommandSyntaxException {
        if (this.reader.canRead(3) && !StringReader.isQuotedStringStart((char)this.reader.peek(1)) && this.reader.peek(2) == ';') {
            return this.readArrayTag();
        }
        return this.readListTag();
    }

    public NBTTagCompound readStruct() throws CommandSyntaxException {
        this.expect('{');
        NBTTagCompound var0 = new NBTTagCompound();
        this.reader.skipWhitespace();
        while (this.reader.canRead() && this.reader.peek() != '}') {
            int var1 = this.reader.getCursor();
            String var2 = this.readKey();
            if (var2.isEmpty()) {
                this.reader.setCursor(var1);
                throw ERROR_EXPECTED_KEY.createWithContext((ImmutableStringReader)this.reader);
            }
            this.expect(':');
            var0.put(var2, this.readValue());
            if (!this.hasElementSeparator()) break;
            if (this.reader.canRead()) continue;
            throw ERROR_EXPECTED_KEY.createWithContext((ImmutableStringReader)this.reader);
        }
        this.expect('}');
        return var0;
    }

    private NBTBase readListTag() throws CommandSyntaxException {
        this.expect('[');
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        NBTTagList var0 = new NBTTagList();
        NBTTagType<?> var1 = null;
        while (this.reader.peek() != ']') {
            int var2 = this.reader.getCursor();
            NBTBase var3 = this.readValue();
            NBTTagType<?> var4 = var3.getType();
            if (var1 == null) {
                var1 = var4;
            } else if (var4 != var1) {
                this.reader.setCursor(var2);
                throw ERROR_INSERT_MIXED_LIST.createWithContext((ImmutableStringReader)this.reader, (Object)var4.getPrettyName(), (Object)var1.getPrettyName());
            }
            var0.add(var3);
            if (!this.hasElementSeparator()) break;
            if (this.reader.canRead()) continue;
            throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        this.expect(']');
        return var0;
    }

    public NBTBase readArrayTag() throws CommandSyntaxException {
        this.expect('[');
        int var0 = this.reader.getCursor();
        char var1 = this.reader.read();
        this.reader.read();
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        if (var1 == 'B') {
            return new NBTTagByteArray(this.readArray(NBTTagByteArray.TYPE, NBTTagByte.TYPE));
        }
        if (var1 == 'L') {
            return new NBTTagLongArray(this.readArray(NBTTagLongArray.TYPE, NBTTagLong.TYPE));
        }
        if (var1 == 'I') {
            return new NBTTagIntArray(this.readArray(NBTTagIntArray.TYPE, NBTTagInt.TYPE));
        }
        this.reader.setCursor(var0);
        throw ERROR_INVALID_ARRAY.createWithContext((ImmutableStringReader)this.reader, (Object)String.valueOf(var1));
    }

    private <T extends Number> List<T> readArray(NBTTagType<?> var0, NBTTagType<?> var1) throws CommandSyntaxException {
        ArrayList var2 = Lists.newArrayList();
        while (this.reader.peek() != ']') {
            int var3 = this.reader.getCursor();
            NBTBase var4 = this.readValue();
            NBTTagType<?> var5 = var4.getType();
            if (var5 != var1) {
                this.reader.setCursor(var3);
                throw ERROR_INSERT_MIXED_ARRAY.createWithContext((ImmutableStringReader)this.reader, (Object)var5.getPrettyName(), (Object)var0.getPrettyName());
            }
            if (var1 == NBTTagByte.TYPE) {
                var2.add(((NBTNumber)var4).getAsByte());
            } else if (var1 == NBTTagLong.TYPE) {
                var2.add(((NBTNumber)var4).getAsLong());
            } else {
                var2.add(((NBTNumber)var4).getAsInt());
            }
            if (!this.hasElementSeparator()) break;
            if (this.reader.canRead()) continue;
            throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        this.expect(']');
        return var2;
    }

    private boolean hasElementSeparator() {
        this.reader.skipWhitespace();
        if (this.reader.canRead() && this.reader.peek() == ',') {
            this.reader.skip();
            this.reader.skipWhitespace();
            return true;
        }
        return false;
    }

    private void expect(char var0) throws CommandSyntaxException {
        this.reader.skipWhitespace();
        this.reader.expect(var0);
    }
}

