/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.gametest.framework.GameTestHarnessBatch;
import net.minecraft.gametest.framework.GameTestHarnessCollector;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.phys.AxisAlignedBB;
import org.slf4j.Logger;

public class GameTestHarnessBatchRunner {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final BlockPosition firstTestNorthWestCorner;
    final WorldServer level;
    private final GameTestHarnessTicker testTicker;
    private final int testsPerRow;
    private final List<GameTestHarnessInfo> allTestInfos;
    private final List<Pair<GameTestHarnessBatch, Collection<GameTestHarnessInfo>>> batches;
    private int count;
    private AxisAlignedBB rowBounds;
    private final BlockPosition.MutableBlockPosition nextTestNorthWestCorner;

    public GameTestHarnessBatchRunner(Collection<GameTestHarnessBatch> var02, BlockPosition var1, EnumBlockRotation var2, WorldServer var3, GameTestHarnessTicker var4, int var5) {
        this.nextTestNorthWestCorner = var1.mutable();
        this.rowBounds = new AxisAlignedBB(this.nextTestNorthWestCorner);
        this.firstTestNorthWestCorner = var1;
        this.level = var3;
        this.testTicker = var4;
        this.testsPerRow = var5;
        this.batches = (List)var02.stream().map(var22 -> {
            Collection var3 = (Collection)var22.getTestFunctions().stream().map(var2 -> new GameTestHarnessInfo((GameTestHarnessTestFunction)var2, var2, var3)).collect(ImmutableList.toImmutableList());
            return Pair.of((Object)var22, (Object)var3);
        }).collect(ImmutableList.toImmutableList());
        this.allTestInfos = (List)this.batches.stream().flatMap(var0 -> ((Collection)var0.getSecond()).stream()).collect(ImmutableList.toImmutableList());
    }

    public List<GameTestHarnessInfo> getTestInfos() {
        return this.allTestInfos;
    }

    public void start() {
        this.runBatch(0);
    }

    void runBatch(final int var0) {
        if (var0 >= this.batches.size()) {
            return;
        }
        Pair<GameTestHarnessBatch, Collection<GameTestHarnessInfo>> var12 = this.batches.get(var0);
        final GameTestHarnessBatch var2 = (GameTestHarnessBatch)var12.getFirst();
        Collection var3 = (Collection)var12.getSecond();
        Map<GameTestHarnessInfo, BlockPosition> var4 = this.createStructuresForBatch(var3);
        String var5 = var2.getName();
        LOGGER.info("Running test batch '{}' ({} tests)...", (Object)var5, (Object)var3.size());
        var2.runBeforeBatchFunction(this.level);
        final GameTestHarnessCollector var6 = new GameTestHarnessCollector();
        var3.forEach(var6::addTestToTrack);
        var6.addListener(new GameTestHarnessListener(){

            private void testCompleted() {
                if (var6.isDone()) {
                    var2.runAfterBatchFunction(GameTestHarnessBatchRunner.this.level);
                    GameTestHarnessBatchRunner.this.runBatch(var0 + 1);
                }
            }

            @Override
            public void testStructureLoaded(GameTestHarnessInfo var02) {
            }

            @Override
            public void testPassed(GameTestHarnessInfo var02) {
                this.testCompleted();
            }

            @Override
            public void testFailed(GameTestHarnessInfo var02) {
                this.testCompleted();
            }
        });
        var3.forEach(var1 -> {
            BlockPosition var2 = (BlockPosition)var4.get(var1);
            GameTestHarnessRunner.runTest(var1, var2, this.testTicker);
        });
    }

    private Map<GameTestHarnessInfo, BlockPosition> createStructuresForBatch(Collection<GameTestHarnessInfo> var0) {
        HashMap var1 = Maps.newHashMap();
        for (GameTestHarnessInfo var3 : var0) {
            BlockPosition var4 = new BlockPosition(this.nextTestNorthWestCorner);
            TileEntityStructure var5 = GameTestHarnessStructures.spawnStructure(var3.getStructureName(), var4, var3.getRotation(), 2, this.level, true);
            AxisAlignedBB var6 = GameTestHarnessStructures.getStructureBounds(var5);
            var3.setStructureBlockPos(var5.getBlockPos());
            var1.put(var3, new BlockPosition(this.nextTestNorthWestCorner));
            this.rowBounds = this.rowBounds.minmax(var6);
            this.nextTestNorthWestCorner.move((int)var6.getXsize() + 5, 0, 0);
            if (this.count++ % this.testsPerRow != this.testsPerRow - 1) continue;
            this.nextTestNorthWestCorner.move(0, 0, (int)this.rowBounds.getZsize() + 6);
            this.nextTestNorthWestCorner.setX(this.firstTestNorthWestCorner.getX());
            this.rowBounds = new AxisAlignedBB(this.nextTestNorthWestCorner);
        }
        return var1;
    }
}

