/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.AncientCityStructurePieces;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.TrailRuinsStructurePools;
import net.minecraft.data.worldgen.WorldGenFeatureBastionPieces;
import net.minecraft.data.worldgen.WorldGenFeaturePillagerOutpostPieces;
import net.minecraft.data.worldgen.WorldGenFeatureVillages;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;

public class WorldGenFeaturePieces {
    public static final ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> EMPTY = WorldGenFeaturePieces.createKey("empty");

    public static ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> createKey(String var0) {
        return ResourceKey.create(Registries.TEMPLATE_POOL, new MinecraftKey(var0));
    }

    public static void register(BootstapContext<WorldGenFeatureDefinedStructurePoolTemplate> var0, String var1, WorldGenFeatureDefinedStructurePoolTemplate var2) {
        var0.register(WorldGenFeaturePieces.createKey(var1), var2);
    }

    public static void bootstrap(BootstapContext<WorldGenFeatureDefinedStructurePoolTemplate> var0) {
        HolderGetter<WorldGenFeatureDefinedStructurePoolTemplate> var1 = var0.lookup(Registries.TEMPLATE_POOL);
        Holder.c<WorldGenFeatureDefinedStructurePoolTemplate> var2 = var1.getOrThrow(EMPTY);
        var0.register(EMPTY, new WorldGenFeatureDefinedStructurePoolTemplate(var2, (List<Pair<Function<WorldGenFeatureDefinedStructurePoolTemplate.Matching, ? extends WorldGenFeatureDefinedStructurePoolStructure>, Integer>>)ImmutableList.of(), WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID));
        WorldGenFeatureBastionPieces.bootstrap(var0);
        WorldGenFeaturePillagerOutpostPieces.bootstrap(var0);
        WorldGenFeatureVillages.bootstrap(var0);
        AncientCityStructurePieces.bootstrap(var0);
        TrailRuinsStructurePools.bootstrap(var0);
    }
}

