/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.CustomFunctionData;

public class CustomFunction {
    private final d[] entries;
    final MinecraftKey id;

    public CustomFunction(MinecraftKey var0, d[] var1) {
        this.id = var0;
        this.entries = var1;
    }

    public MinecraftKey getId() {
        return this.id;
    }

    public d[] getEntries() {
        return this.entries;
    }

    public CustomFunction instantiate(@Nullable NBTTagCompound var0, com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> var1, CommandListenerWrapper var2) throws FunctionInstantiationException {
        return this;
    }

    private static boolean shouldConcatenateNextLine(CharSequence var0) {
        int var1 = var0.length();
        return var1 > 0 && var0.charAt(var1 - 1) == '\\';
    }

    public static CustomFunction fromLines(MinecraftKey var0, com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> var1, CommandListenerWrapper var2, List<String> var3) {
        ArrayList<Object> var4 = new ArrayList<Object>(var3.size());
        ObjectArraySet var5 = new ObjectArraySet();
        for (int var6 = 0; var6 < var3.size(); ++var6) {
            String var9;
            Object var11;
            StringBuilder var10;
            int var7 = var6 + 1;
            String var8 = var3.get(var6).trim();
            if (CustomFunction.shouldConcatenateNextLine(var8)) {
                var10 = new StringBuilder(var8);
                do {
                    if (++var6 == var3.size()) {
                        throw new IllegalArgumentException("Line continuation at end of file");
                    }
                    var10.deleteCharAt(var10.length() - 1);
                    var11 = var3.get(var6).trim();
                    var10.append((String)var11);
                } while (CustomFunction.shouldConcatenateNextLine(var10));
                var9 = var10.toString();
            } else {
                var9 = var8;
            }
            var10 = new StringReader(var9);
            if (!var10.canRead() || var10.peek() == '#') continue;
            if (var10.peek() == '/') {
                var10.skip();
                if (var10.peek() == '/') {
                    throw new IllegalArgumentException("Unknown or invalid command '" + var9 + "' on line " + var7 + " (if you intended to make a comment, use '#' not '//')");
                }
                var11 = var10.readUnquotedString();
                throw new IllegalArgumentException("Unknown or invalid command '" + var9 + "' on line " + var7 + " (did you mean '" + (String)var11 + "'? Do not use a preceding forwards slash.)");
            }
            if (var10.peek() == '$') {
                var11 = CustomFunction.decomposeMacro(var9.substring(1), var7);
                var4.add(var11);
                var5.addAll(((f)var11).parameters());
                continue;
            }
            try {
                var11 = var1.parse((StringReader)var10, (Object)var2);
                if (var11.getReader().canRead()) {
                    throw CommandDispatcher.getParseException(var11);
                }
                var4.add(new b((ParseResults<CommandListenerWrapper>)var11));
                continue;
            }
            catch (CommandSyntaxException var112) {
                throw new IllegalArgumentException("Whilst parsing command on line " + var7 + ": " + var112.getMessage());
            }
        }
        if (var5.isEmpty()) {
            return new CustomFunction(var0, (d[])var4.toArray(d[]::new));
        }
        return new c(var0, (d[])var4.toArray(d[]::new), List.copyOf(var5));
    }

    @VisibleForTesting
    public static f decomposeMacro(String var0, int var1) {
        ImmutableList.Builder var2 = ImmutableList.builder();
        ImmutableList.Builder var3 = ImmutableList.builder();
        int var4 = var0.length();
        int var5 = 0;
        int var6 = var0.indexOf(36);
        while (var6 != -1) {
            if (var6 == var4 - 1 || var0.charAt(var6 + 1) != '(') {
                var6 = var0.indexOf(36, var6 + 1);
                continue;
            }
            var2.add((Object)var0.substring(var5, var6));
            int var7 = var0.indexOf(41, var6 + 1);
            if (var7 == -1) {
                throw new IllegalArgumentException("Unterminated macro variable in macro '" + var0 + "' on line " + var1);
            }
            String var8 = var0.substring(var6 + 2, var7);
            if (!CustomFunction.isValidVariableName(var8)) {
                throw new IllegalArgumentException("Invalid macro variable name '" + var8 + "' on line " + var1);
            }
            var3.add((Object)var8);
            var5 = var7 + 1;
            var6 = var0.indexOf(36, var5);
        }
        if (var5 == 0) {
            throw new IllegalArgumentException("Macro without variables on line " + var1);
        }
        if (var5 != var4) {
            var2.add((Object)var0.substring(var5));
        }
        return new f((List<String>)var2.build(), (List<String>)var3.build());
    }

    private static boolean isValidVariableName(String var0) {
        for (int var1 = 0; var1 < var0.length(); ++var1) {
            char var2 = var0.charAt(var1);
            if (Character.isLetterOrDigit(var2) || var2 == '_') continue;
            return false;
        }
        return true;
    }

    @FunctionalInterface
    public static interface d {
        public void execute(CustomFunctionData var1, CommandListenerWrapper var2, Deque<CustomFunctionData.QueuedCommand> var3, int var4, int var5, @Nullable CustomFunctionData.TraceCallbacks var6) throws CommandSyntaxException;
    }

    public static class f
    implements d {
        private final List<String> segments;
        private final List<String> parameters;

        public f(List<String> var0, List<String> var1) {
            this.segments = var0;
            this.parameters = var1;
        }

        public List<String> parameters() {
            return this.parameters;
        }

        public String substitute(List<String> var0) {
            StringBuilder var1 = new StringBuilder();
            for (int var2 = 0; var2 < this.parameters.size(); ++var2) {
                var1.append(this.segments.get(var2)).append(var0.get(var2));
            }
            if (this.segments.size() > this.parameters.size()) {
                var1.append(this.segments.get(this.segments.size() - 1));
            }
            return var1.toString();
        }

        @Override
        public void execute(CustomFunctionData var0, CommandListenerWrapper var1, Deque<CustomFunctionData.QueuedCommand> var2, int var3, int var4, @Nullable CustomFunctionData.TraceCallbacks var5) throws CommandSyntaxException {
            throw new IllegalStateException("Tried to execute an uninstantiated macro");
        }
    }

    public static class b
    implements d {
        private final ParseResults<CommandListenerWrapper> parse;

        public b(ParseResults<CommandListenerWrapper> var0) {
            this.parse = var0;
        }

        @Override
        public void execute(CustomFunctionData var0, CommandListenerWrapper var1, Deque<CustomFunctionData.QueuedCommand> var2, int var3, int var4, @Nullable CustomFunctionData.TraceCallbacks var5) throws CommandSyntaxException {
            if (var5 != null) {
                String var6 = this.parse.getReader().getString();
                var5.onCommand(var4, var6);
                int var7 = this.execute(var0, var1);
                var5.onReturn(var4, var6, var7);
            } else {
                this.execute(var0, var1);
            }
        }

        private int execute(CustomFunctionData var0, CommandListenerWrapper var12) throws CommandSyntaxException {
            return var0.getDispatcher().execute(CommandDispatcher.mapSource(this.parse, var1 -> var12));
        }

        public String toString() {
            return this.parse.getReader().getString();
        }
    }

    static class c
    extends CustomFunction {
        private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#");
        private final List<String> parameters;
        private static final int MAX_CACHE_ENTRIES = 8;
        private final Object2ObjectLinkedOpenHashMap<List<String>, CustomFunction> cache = new Object2ObjectLinkedOpenHashMap(8, 0.25f);

        public c(MinecraftKey var0, d[] var1, List<String> var2) {
            super(var0, var1);
            this.parameters = var2;
        }

        @Override
        public CustomFunction instantiate(@Nullable NBTTagCompound var0, com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> var1, CommandListenerWrapper var2) throws FunctionInstantiationException {
            CustomFunction customFunction;
            if (var0 == null) {
                throw new FunctionInstantiationException(IChatBaseComponent.translatable("commands.function.error.missing_arguments", this.getId()));
            }
            ArrayList<String> var3 = new ArrayList<String>(this.parameters.size());
            for (String string : this.parameters) {
                if (!var0.contains(string)) {
                    throw new FunctionInstantiationException(IChatBaseComponent.translatable("commands.function.error.missing_argument", this.getId(), string));
                }
                var3.add(c.stringify(var0.get(string)));
            }
            CustomFunction var4 = (CustomFunction)this.cache.getAndMoveToLast(var3);
            if (var4 != null) {
                return var4;
            }
            if (this.cache.size() >= 8) {
                this.cache.removeFirst();
            }
            if ((customFunction = this.substituteAndParse(var3, var1, var2)) != null) {
                this.cache.put(var3, (Object)customFunction);
            }
            return customFunction;
        }

        private static String stringify(NBTBase var0) {
            if (var0 instanceof NBTTagFloat) {
                NBTTagFloat var1 = (NBTTagFloat)var0;
                return DECIMAL_FORMAT.format(var1.getAsFloat());
            }
            if (var0 instanceof NBTTagDouble) {
                NBTTagDouble var2 = (NBTTagDouble)var0;
                return DECIMAL_FORMAT.format(var2.getAsDouble());
            }
            if (var0 instanceof NBTTagByte) {
                NBTTagByte var3 = (NBTTagByte)var0;
                return String.valueOf(var3.getAsByte());
            }
            if (var0 instanceof NBTTagShort) {
                NBTTagShort var4 = (NBTTagShort)var0;
                return String.valueOf(var4.getAsShort());
            }
            if (var0 instanceof NBTTagLong) {
                NBTTagLong var5 = (NBTTagLong)var0;
                return String.valueOf(var5.getAsLong());
            }
            return var0.getAsString();
        }

        private CustomFunction substituteAndParse(List<String> var0, com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> var1, CommandListenerWrapper var2) throws FunctionInstantiationException {
            d[] var3 = this.getEntries();
            d[] var4 = new d[var3.length];
            for (int var5 = 0; var5 < var3.length; ++var5) {
                d var6 = var3[var5];
                if (var6 instanceof f) {
                    f var7 = (f)var6;
                    List<String> var8 = var7.parameters();
                    ArrayList<String> var9 = new ArrayList<String>(var8.size());
                    for (String var11 : var8) {
                        var9.add(var0.get(this.parameters.indexOf(var11)));
                    }
                    String var10 = var7.substitute(var9);
                    try {
                        String var11;
                        var11 = var1.parse(var10, (Object)var2);
                        if (var11.getReader().canRead()) {
                            throw CommandDispatcher.getParseException(var11);
                        }
                        var4[var5] = new b((ParseResults<CommandListenerWrapper>)var11);
                        continue;
                    }
                    catch (CommandSyntaxException var11) {
                        throw new FunctionInstantiationException(IChatBaseComponent.translatable("commands.function.error.parse", this.getId(), var10, var11.getMessage()));
                    }
                }
                var4[var5] = var6;
            }
            MinecraftKey var5 = this.getId();
            return new CustomFunction(new MinecraftKey(var5.getNamespace(), var5.getPath() + "/" + var0.hashCode()), var4);
        }

        static {
            DECIMAL_FORMAT.setMaximumFractionDigits(15);
            DECIMAL_FORMAT.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
        }
    }

    public static class a {
        public static final a NONE = new a((MinecraftKey)null);
        @Nullable
        private final MinecraftKey id;
        private boolean resolved;
        private Optional<CustomFunction> function = Optional.empty();

        public a(@Nullable MinecraftKey var0) {
            this.id = var0;
        }

        public a(CustomFunction var0) {
            this.resolved = true;
            this.id = null;
            this.function = Optional.of(var0);
        }

        public Optional<CustomFunction> get(CustomFunctionData var0) {
            if (!this.resolved) {
                if (this.id != null) {
                    this.function = var0.get(this.id);
                }
                this.resolved = true;
            }
            return this.function;
        }

        @Nullable
        public MinecraftKey getId() {
            return this.function.map(var0 -> var0.id).orElse(this.id);
        }
    }

    public static class e
    implements d {
        private final a function;

        public e(CustomFunction var0) {
            this.function = new a(var0);
        }

        @Override
        public void execute(CustomFunctionData var0, CommandListenerWrapper var1, Deque<CustomFunctionData.QueuedCommand> var2, int var3, int var4, @Nullable CustomFunctionData.TraceCallbacks var52) {
            SystemUtils.ifElse(this.function.get(var0), var5 -> {
                d[] var6 = var5.getEntries();
                if (var52 != null) {
                    var52.onCall(var4, var5.getId(), var6.length);
                }
                int var7 = var3 - var2.size();
                int var8 = Math.min(var6.length, var7);
                for (int var9 = var8 - 1; var9 >= 0; --var9) {
                    var2.addFirst(new CustomFunctionData.QueuedCommand(var1, var4 + 1, var6[var9]));
                }
            }, () -> {
                if (var52 != null) {
                    var52.onCall(var4, this.function.getId(), -1);
                }
            });
        }

        public String toString() {
            return "function " + this.function.getId();
        }
    }
}

