/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ResultConsumer;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TaskChainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;

public class CommandListenerWrapper
implements ICompletionProvider {
    public static final SimpleCommandExceptionType ERROR_NOT_PLAYER = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("permissions.requires.player"));
    public static final SimpleCommandExceptionType ERROR_NOT_ENTITY = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("permissions.requires.entity"));
    public final ICommandListener source;
    private final Vec3D worldPosition;
    private final WorldServer level;
    private final int permissionLevel;
    private final String textName;
    private final IChatBaseComponent displayName;
    private final MinecraftServer server;
    private final boolean silent;
    @Nullable
    private final Entity entity;
    @Nullable
    private final ResultConsumer<CommandListenerWrapper> consumer;
    private final ArgumentAnchor.Anchor anchor;
    private final Vec2F rotation;
    private final CommandSigningContext signingContext;
    private final TaskChainer chatMessageChainer;
    private final IntConsumer returnValueConsumer;

    public CommandListenerWrapper(ICommandListener var02, Vec3D var12, Vec2F var22, WorldServer var3, int var4, String var5, IChatBaseComponent var6, MinecraftServer var7, @Nullable Entity var8) {
        this(var02, var12, var22, var3, var4, var5, var6, var7, var8, false, (ResultConsumer<CommandListenerWrapper>)((ResultConsumer)(var0, var1, var2) -> {}), ArgumentAnchor.Anchor.FEET, CommandSigningContext.ANONYMOUS, TaskChainer.immediate(var7), var0 -> {});
    }

    protected CommandListenerWrapper(ICommandListener var0, Vec3D var1, Vec2F var2, WorldServer var3, int var4, String var5, IChatBaseComponent var6, MinecraftServer var7, @Nullable Entity var8, boolean var9, @Nullable ResultConsumer<CommandListenerWrapper> var10, ArgumentAnchor.Anchor var11, CommandSigningContext var12, TaskChainer var13, IntConsumer var14) {
        this.source = var0;
        this.worldPosition = var1;
        this.level = var3;
        this.silent = var9;
        this.entity = var8;
        this.permissionLevel = var4;
        this.textName = var5;
        this.displayName = var6;
        this.server = var7;
        this.consumer = var10;
        this.anchor = var11;
        this.rotation = var2;
        this.signingContext = var12;
        this.chatMessageChainer = var13;
        this.returnValueConsumer = var14;
    }

    public CommandListenerWrapper withSource(ICommandListener var0) {
        if (this.source == var0) {
            return this;
        }
        return new CommandListenerWrapper(var0, this.worldPosition, this.rotation, this.level, this.permissionLevel, this.textName, this.displayName, this.server, this.entity, this.silent, this.consumer, this.anchor, this.signingContext, this.chatMessageChainer, this.returnValueConsumer);
    }

    public CommandListenerWrapper withEntity(Entity var0) {
        if (this.entity == var0) {
            return this;
        }
        return new CommandListenerWrapper(this.source, this.worldPosition, this.rotation, this.level, this.permissionLevel, var0.getName().getString(), var0.getDisplayName(), this.server, var0, this.silent, this.consumer, this.anchor, this.signingContext, this.chatMessageChainer, this.returnValueConsumer);
    }

    public CommandListenerWrapper withPosition(Vec3D var0) {
        if (this.worldPosition.equals(var0)) {
            return this;
        }
        return new CommandListenerWrapper(this.source, var0, this.rotation, this.level, this.permissionLevel, this.textName, this.displayName, this.server, this.entity, this.silent, this.consumer, this.anchor, this.signingContext, this.chatMessageChainer, this.returnValueConsumer);
    }

    public CommandListenerWrapper withRotation(Vec2F var0) {
        if (this.rotation.equals(var0)) {
            return this;
        }
        return new CommandListenerWrapper(this.source, this.worldPosition, var0, this.level, this.permissionLevel, this.textName, this.displayName, this.server, this.entity, this.silent, this.consumer, this.anchor, this.signingContext, this.chatMessageChainer, this.returnValueConsumer);
    }

    public CommandListenerWrapper withCallback(ResultConsumer<CommandListenerWrapper> var0) {
        if (Objects.equals(this.consumer, var0)) {
            return this;
        }
        return new CommandListenerWrapper(this.source, this.worldPosition, this.rotation, this.level, this.permissionLevel, this.textName, this.displayName, this.server, this.entity, this.silent, var0, this.anchor, this.signingContext, this.chatMessageChainer, this.returnValueConsumer);
    }

    public CommandListenerWrapper withCallback(ResultConsumer<CommandListenerWrapper> var0, BinaryOperator<ResultConsumer<CommandListenerWrapper>> var1) {
        ResultConsumer var2 = (ResultConsumer)var1.apply(this.consumer, var0);
        return this.withCallback((ResultConsumer<CommandListenerWrapper>)var2);
    }

    public CommandListenerWrapper withSuppressedOutput() {
        if (this.silent || this.source.alwaysAccepts()) {
            return this;
        }
        return new CommandListenerWrapper(this.source, this.worldPosition, this.rotation, this.level, this.permissionLevel, this.textName, this.displayName, this.server, this.entity, true, this.consumer, this.anchor, this.signingContext, this.chatMessageChainer, this.returnValueConsumer);
    }

    public CommandListenerWrapper withPermission(int var0) {
        if (var0 == this.permissionLevel) {
            return this;
        }
        return new CommandListenerWrapper(this.source, this.worldPosition, this.rotation, this.level, var0, this.textName, this.displayName, this.server, this.entity, this.silent, this.consumer, this.anchor, this.signingContext, this.chatMessageChainer, this.returnValueConsumer);
    }

    public CommandListenerWrapper withMaximumPermission(int var0) {
        if (var0 <= this.permissionLevel) {
            return this;
        }
        return new CommandListenerWrapper(this.source, this.worldPosition, this.rotation, this.level, var0, this.textName, this.displayName, this.server, this.entity, this.silent, this.consumer, this.anchor, this.signingContext, this.chatMessageChainer, this.returnValueConsumer);
    }

    public CommandListenerWrapper withAnchor(ArgumentAnchor.Anchor var0) {
        if (var0 == this.anchor) {
            return this;
        }
        return new CommandListenerWrapper(this.source, this.worldPosition, this.rotation, this.level, this.permissionLevel, this.textName, this.displayName, this.server, this.entity, this.silent, this.consumer, var0, this.signingContext, this.chatMessageChainer, this.returnValueConsumer);
    }

    public CommandListenerWrapper withLevel(WorldServer var0) {
        if (var0 == this.level) {
            return this;
        }
        double var1 = DimensionManager.getTeleportationScale(this.level.dimensionType(), var0.dimensionType());
        Vec3D var3 = new Vec3D(this.worldPosition.x * var1, this.worldPosition.y, this.worldPosition.z * var1);
        return new CommandListenerWrapper(this.source, var3, this.rotation, var0, this.permissionLevel, this.textName, this.displayName, this.server, this.entity, this.silent, this.consumer, this.anchor, this.signingContext, this.chatMessageChainer, this.returnValueConsumer);
    }

    public CommandListenerWrapper facing(Entity var0, ArgumentAnchor.Anchor var1) {
        return this.facing(var1.apply(var0));
    }

    public CommandListenerWrapper facing(Vec3D var0) {
        Vec3D var1 = this.anchor.apply(this);
        double var2 = var0.x - var1.x;
        double var4 = var0.y - var1.y;
        double var6 = var0.z - var1.z;
        double var8 = Math.sqrt(var2 * var2 + var6 * var6);
        float var10 = MathHelper.wrapDegrees((float)(-(MathHelper.atan2(var4, var8) * 57.2957763671875)));
        float var11 = MathHelper.wrapDegrees((float)(MathHelper.atan2(var6, var2) * 57.2957763671875) - 90.0f);
        return this.withRotation(new Vec2F(var10, var11));
    }

    public CommandListenerWrapper withSigningContext(CommandSigningContext var0, TaskChainer var1) {
        if (var0 == this.signingContext && var1 == this.chatMessageChainer) {
            return this;
        }
        return new CommandListenerWrapper(this.source, this.worldPosition, this.rotation, this.level, this.permissionLevel, this.textName, this.displayName, this.server, this.entity, this.silent, this.consumer, this.anchor, var0, var1, this.returnValueConsumer);
    }

    public CommandListenerWrapper withReturnValueConsumer(IntConsumer var0) {
        if (var0 == this.returnValueConsumer) {
            return this;
        }
        return new CommandListenerWrapper(this.source, this.worldPosition, this.rotation, this.level, this.permissionLevel, this.textName, this.displayName, this.server, this.entity, this.silent, this.consumer, this.anchor, this.signingContext, this.chatMessageChainer, var0);
    }

    public IChatBaseComponent getDisplayName() {
        return this.displayName;
    }

    public String getTextName() {
        return this.textName;
    }

    @Override
    public boolean hasPermission(int var0) {
        return this.permissionLevel >= var0;
    }

    public Vec3D getPosition() {
        return this.worldPosition;
    }

    public WorldServer getLevel() {
        return this.level;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity;
    }

    public Entity getEntityOrException() throws CommandSyntaxException {
        if (this.entity == null) {
            throw ERROR_NOT_ENTITY.create();
        }
        return this.entity;
    }

    public EntityPlayer getPlayerOrException() throws CommandSyntaxException {
        Entity entity = this.entity;
        if (entity instanceof EntityPlayer) {
            EntityPlayer var0 = (EntityPlayer)entity;
            return var0;
        }
        throw ERROR_NOT_PLAYER.create();
    }

    @Nullable
    public EntityPlayer getPlayer() {
        EntityPlayer var0;
        Entity entity = this.entity;
        return entity instanceof EntityPlayer ? (var0 = (EntityPlayer)entity) : null;
    }

    public boolean isPlayer() {
        return this.entity instanceof EntityPlayer;
    }

    public Vec2F getRotation() {
        return this.rotation;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public ArgumentAnchor.Anchor getAnchor() {
        return this.anchor;
    }

    public CommandSigningContext getSigningContext() {
        return this.signingContext;
    }

    public TaskChainer getChatMessageChainer() {
        return this.chatMessageChainer;
    }

    public IntConsumer getReturnValueConsumer() {
        return this.returnValueConsumer;
    }

    public boolean shouldFilterMessageTo(EntityPlayer var0) {
        EntityPlayer var1 = this.getPlayer();
        if (var0 == var1) {
            return false;
        }
        return var1 != null && var1.isTextFilteringEnabled() || var0.isTextFilteringEnabled();
    }

    public void sendChatMessage(OutgoingChatMessage var0, boolean var1, ChatMessageType.a var2) {
        if (this.silent) {
            return;
        }
        EntityPlayer var3 = this.getPlayer();
        if (var3 != null) {
            var3.sendChatMessage(var0, var1, var2);
        } else {
            this.source.sendSystemMessage(var2.decorate(var0.content()));
        }
    }

    public void sendSystemMessage(IChatBaseComponent var0) {
        if (this.silent) {
            return;
        }
        EntityPlayer var1 = this.getPlayer();
        if (var1 != null) {
            var1.sendSystemMessage(var0);
        } else {
            this.source.sendSystemMessage(var0);
        }
    }

    public void sendSuccess(Supplier<IChatBaseComponent> var0, boolean var1) {
        boolean var3;
        boolean var2 = this.source.acceptsSuccess() && !this.silent;
        boolean bl = var3 = var1 && this.source.shouldInformAdmins() && !this.silent;
        if (!var2 && !var3) {
            return;
        }
        IChatBaseComponent var4 = var0.get();
        if (var2) {
            this.source.sendSystemMessage(var4);
        }
        if (var3) {
            this.broadcastToAdmins(var4);
        }
    }

    private void broadcastToAdmins(IChatBaseComponent var0) {
        IChatMutableComponent var1 = IChatBaseComponent.translatable("chat.type.admin", this.getDisplayName(), var0).withStyle(EnumChatFormat.GRAY, EnumChatFormat.ITALIC);
        if (this.server.getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK)) {
            for (EntityPlayer var3 : this.server.getPlayerList().getPlayers()) {
                if (var3 == this.source || !this.server.getPlayerList().isOp(var3.getGameProfile())) continue;
                var3.sendSystemMessage(var1);
            }
        }
        if (this.source != this.server && this.server.getGameRules().getBoolean(GameRules.RULE_LOGADMINCOMMANDS)) {
            this.server.sendSystemMessage(var1);
        }
    }

    public void sendFailure(IChatBaseComponent var0) {
        if (this.source.acceptsFailure() && !this.silent) {
            this.source.sendSystemMessage(IChatBaseComponent.empty().append(var0).withStyle(EnumChatFormat.RED));
        }
    }

    public void onCommandComplete(CommandContext<CommandListenerWrapper> var0, boolean var1, int var2) {
        if (this.consumer != null) {
            this.consumer.onCommandComplete(var0, var1, var2);
        }
    }

    @Override
    public Collection<String> getOnlinePlayerNames() {
        return Lists.newArrayList((Object[])this.server.getPlayerNames());
    }

    @Override
    public Collection<String> getAllTeams() {
        return this.server.getScoreboard().getTeamNames();
    }

    @Override
    public Stream<MinecraftKey> getAvailableSounds() {
        return BuiltInRegistries.SOUND_EVENT.stream().map(SoundEffect::getLocation);
    }

    @Override
    public Stream<MinecraftKey> getRecipeNames() {
        return this.server.getRecipeManager().getRecipeIds();
    }

    @Override
    public CompletableFuture<Suggestions> customSuggestion(CommandContext<?> var0) {
        return Suggestions.empty();
    }

    @Override
    public CompletableFuture<Suggestions> suggestRegistryElements(ResourceKey<? extends IRegistry<?>> var0, ICompletionProvider.a var1, SuggestionsBuilder var22, CommandContext<?> var3) {
        return this.registryAccess().registry(var0).map(var2 -> {
            this.suggestRegistryElements((IRegistry<?>)var2, var1, var22);
            return var22.buildFuture();
        }).orElseGet(Suggestions::empty);
    }

    @Override
    public Set<ResourceKey<World>> levels() {
        return this.server.levelKeys();
    }

    @Override
    public IRegistryCustom registryAccess() {
        return this.server.registryAccess();
    }

    @Override
    public FeatureFlagSet enabledFeatures() {
        return this.level.enabledFeatures();
    }
}

