/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;

public class PickedUpItemTrigger
extends CriterionTriggerAbstract<a> {
    @Override
    protected a createInstance(JsonObject var0, Optional<ContextAwarePredicate> var1, LootDeserializationContext var2) {
        Optional<CriterionConditionItem> var3 = CriterionConditionItem.fromJson(var0.get("item"));
        Optional<ContextAwarePredicate> var4 = CriterionConditionEntity.fromJson(var0, "entity", var2);
        return new a(var1, var3, var4);
    }

    public void trigger(EntityPlayer var0, ItemStack var1, @Nullable Entity var2) {
        LootTableInfo var32 = CriterionConditionEntity.createContext(var0, var2);
        this.trigger(var0, var3 -> var3.matches(var0, var1, var32));
    }

    @Override
    protected /* synthetic */ CriterionTriggerAbstract.a createInstance(JsonObject jsonObject, Optional optional, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, optional, lootDeserializationContext);
    }

    public static class a
    extends CriterionInstanceAbstract {
        private final Optional<CriterionConditionItem> item;
        private final Optional<ContextAwarePredicate> entity;

        public a(Optional<ContextAwarePredicate> var0, Optional<CriterionConditionItem> var1, Optional<ContextAwarePredicate> var2) {
            super(var0);
            this.item = var1;
            this.entity = var2;
        }

        public static Criterion<a> thrownItemPickedUpByEntity(ContextAwarePredicate var0, Optional<CriterionConditionItem> var1, Optional<ContextAwarePredicate> var2) {
            return CriterionTriggers.THROWN_ITEM_PICKED_UP_BY_ENTITY.createCriterion(new a(Optional.of(var0), var1, var2));
        }

        public static Criterion<a> thrownItemPickedUpByPlayer(Optional<ContextAwarePredicate> var0, Optional<CriterionConditionItem> var1, Optional<ContextAwarePredicate> var2) {
            return CriterionTriggers.THROWN_ITEM_PICKED_UP_BY_PLAYER.createCriterion(new a(var0, var1, var2));
        }

        public boolean matches(EntityPlayer var0, ItemStack var1, LootTableInfo var2) {
            if (this.item.isPresent() && !this.item.get().matches(var1)) {
                return false;
            }
            return !this.entity.isPresent() || this.entity.get().matches(var2);
        }

        @Override
        public JsonObject serializeToJson() {
            JsonObject var0 = super.serializeToJson();
            this.item.ifPresent(var1 -> var0.add("item", var1.serializeToJson()));
            this.entity.ifPresent(var1 -> var0.add("entity", var1.toJson()));
            return var0;
        }
    }
}

