/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonArray;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import net.minecraft.SystemUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.slf4j.Logger;

public class LootDeserializationContext {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final MinecraftKey id;
    private final LootDataManager lootData;

    public LootDeserializationContext(MinecraftKey var0, LootDataManager var1) {
        this.id = var0;
        this.lootData = var1;
    }

    public final List<LootItemCondition> deserializeConditions(JsonArray var0, String var12, LootContextParameterSet var22) {
        List var3 = (List)SystemUtils.getOrThrow(LootItemConditions.CODEC.listOf().parse((DynamicOps)JsonOps.INSTANCE, (Object)var0), JsonParseException::new);
        LootCollector var4 = new LootCollector(var22, this.lootData);
        for (LootItemCondition var6 : var3) {
            var6.validate(var4);
            var4.getProblems().forEach((var1, var2) -> LOGGER.warn("Found validation problem in advancement trigger {}/{}: {}", new Object[]{var12, var1, var2}));
        }
        return var3;
    }

    public MinecraftKey getAdvancementId() {
        return this.id;
    }
}

