/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.level.storage.loot.LootTableInfo;

public class LightningStrikeTrigger
extends CriterionTriggerAbstract<a> {
    @Override
    public a createInstance(JsonObject var0, Optional<ContextAwarePredicate> var1, LootDeserializationContext var2) {
        Optional<ContextAwarePredicate> var3 = CriterionConditionEntity.fromJson(var0, "lightning", var2);
        Optional<ContextAwarePredicate> var4 = CriterionConditionEntity.fromJson(var0, "bystander", var2);
        return new a(var1, var3, var4);
    }

    public void trigger(EntityPlayer var0, EntityLightning var12, List<Entity> var22) {
        List var3 = var22.stream().map(var1 -> CriterionConditionEntity.createContext(var0, var1)).collect(Collectors.toList());
        LootTableInfo var4 = CriterionConditionEntity.createContext(var0, var12);
        this.trigger(var0, var2 -> var2.matches(var4, var3));
    }

    @Override
    public /* synthetic */ CriterionTriggerAbstract.a createInstance(JsonObject jsonObject, Optional optional, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, optional, lootDeserializationContext);
    }

    public static class a
    extends CriterionInstanceAbstract {
        private final Optional<ContextAwarePredicate> lightning;
        private final Optional<ContextAwarePredicate> bystander;

        public a(Optional<ContextAwarePredicate> var0, Optional<ContextAwarePredicate> var1, Optional<ContextAwarePredicate> var2) {
            super(var0);
            this.lightning = var1;
            this.bystander = var2;
        }

        public static Criterion<a> lightningStrike(Optional<CriterionConditionEntity> var0, Optional<CriterionConditionEntity> var1) {
            return CriterionTriggers.LIGHTNING_STRIKE.createCriterion(new a(Optional.empty(), CriterionConditionEntity.wrap(var0), CriterionConditionEntity.wrap(var1)));
        }

        public boolean matches(LootTableInfo var0, List<LootTableInfo> var1) {
            if (this.lightning.isPresent() && !this.lightning.get().matches(var0)) {
                return false;
            }
            if (this.bystander.isPresent()) {
                if (var1.stream().noneMatch(this.bystander.get()::matches)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public JsonObject serializeToJson() {
            JsonObject var0 = super.serializeToJson();
            this.lightning.ifPresent(var1 -> var0.add("lightning", var1.toJson()));
            this.bystander.ifPresent(var1 -> var0.add("bystander", var1.toJson()));
            return var0;
        }
    }
}

