/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionLocation;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionBlockStateProperty;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionLocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionMatchTool;

public class ItemUsedOnLocationTrigger
extends CriterionTriggerAbstract<a> {
    @Override
    public a createInstance(JsonObject var0, Optional<ContextAwarePredicate> var1, LootDeserializationContext var2) {
        Optional<Optional<ContextAwarePredicate>> var3 = ContextAwarePredicate.fromElement("location", var2, var0.get("location"), LootContextParameterSets.ADVANCEMENT_LOCATION);
        if (var3.isEmpty()) {
            throw new JsonParseException("Failed to parse 'location' field");
        }
        return new a(var1, var3.get());
    }

    public void trigger(EntityPlayer var0, BlockPosition var12, ItemStack var2) {
        WorldServer var3 = var0.serverLevel();
        IBlockData var4 = var3.getBlockState(var12);
        LootParams var5 = new LootParams.a(var3).withParameter(LootContextParameters.ORIGIN, var12.getCenter()).withParameter(LootContextParameters.THIS_ENTITY, var0).withParameter(LootContextParameters.BLOCK_STATE, var4).withParameter(LootContextParameters.TOOL, var2).create(LootContextParameterSets.ADVANCEMENT_LOCATION);
        LootTableInfo var6 = new LootTableInfo.Builder(var5).create(Optional.empty());
        this.trigger(var0, var1 -> var1.matches(var6));
    }

    @Override
    public /* synthetic */ CriterionTriggerAbstract.a createInstance(JsonObject jsonObject, Optional optional, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, optional, lootDeserializationContext);
    }

    public static class a
    extends CriterionInstanceAbstract {
        private final Optional<ContextAwarePredicate> location;

        public a(Optional<ContextAwarePredicate> var0, Optional<ContextAwarePredicate> var1) {
            super(var0);
            this.location = var1;
        }

        public static Criterion<a> placedBlock(Block var0) {
            ContextAwarePredicate var1 = ContextAwarePredicate.create(LootItemConditionBlockStateProperty.hasBlockStateProperties(var0).build());
            return CriterionTriggers.PLACED_BLOCK.createCriterion(new a(Optional.empty(), Optional.of(var1)));
        }

        public static Criterion<a> placedBlock(LootItemCondition.a ... var0) {
            ContextAwarePredicate var1 = ContextAwarePredicate.create((LootItemCondition[])Arrays.stream(var0).map(LootItemCondition.a::build).toArray(LootItemCondition[]::new));
            return CriterionTriggers.PLACED_BLOCK.createCriterion(new a(Optional.empty(), Optional.of(var1)));
        }

        private static a itemUsedOnLocation(CriterionConditionLocation.a var0, CriterionConditionItem.a var1) {
            ContextAwarePredicate var2 = ContextAwarePredicate.create(LootItemConditionLocationCheck.checkLocation(var0).build(), LootItemConditionMatchTool.toolMatches(var1).build());
            return new a(Optional.empty(), Optional.of(var2));
        }

        public static Criterion<a> itemUsedOnBlock(CriterionConditionLocation.a var0, CriterionConditionItem.a var1) {
            return CriterionTriggers.ITEM_USED_ON_BLOCK.createCriterion(a.itemUsedOnLocation(var0, var1));
        }

        public static Criterion<a> allayDropItemOnBlock(CriterionConditionLocation.a var0, CriterionConditionItem.a var1) {
            return CriterionTriggers.ALLAY_DROP_ITEM_ON_BLOCK.createCriterion(a.itemUsedOnLocation(var0, var1));
        }

        public boolean matches(LootTableInfo var0) {
            return this.location.isEmpty() || this.location.get().matches(var0);
        }

        @Override
        public JsonObject serializeToJson() {
            JsonObject var0 = super.serializeToJson();
            this.location.ifPresent(var1 -> var0.add("location", var1.toJson()));
            return var0;
        }
    }
}

