/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;

public record CriterionTriggerProperties(List<c> properties) {
    private static final Codec<List<c>> PROPERTIES_CODEC = Codec.unboundedMap((Codec)Codec.STRING, e.CODEC).xmap(var02 -> var02.entrySet().stream().map(var0 -> new c((String)var0.getKey(), (e)var0.getValue())).toList(), var0 -> var0.stream().collect(Collectors.toMap(c::name, c::valueMatcher)));
    public static final Codec<CriterionTriggerProperties> CODEC = PROPERTIES_CODEC.xmap(CriterionTriggerProperties::new, CriterionTriggerProperties::properties);

    public <S extends IBlockDataHolder<?, S>> boolean matches(BlockStateList<?, S> var0, S var1) {
        for (c var3 : this.properties) {
            if (var3.match(var0, var1)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(IBlockData var0) {
        return this.matches(var0.getBlock().getStateDefinition(), var0);
    }

    public boolean matches(Fluid var0) {
        return this.matches(var0.getType().getStateDefinition(), var0);
    }

    public Optional<String> checkState(BlockStateList<?, ?> var0) {
        for (c var2 : this.properties) {
            Optional<String> var3 = var2.checkState(var0);
            if (!var3.isPresent()) continue;
            return var3;
        }
        return Optional.empty();
    }

    public void checkState(BlockStateList<?, ?> var0, Consumer<String> var1) {
        this.properties.forEach(var2 -> var2.checkState(var0).ifPresent(var1));
    }

    public static Optional<CriterionTriggerProperties> fromJson(@Nullable JsonElement var0) {
        if (var0 == null || var0.isJsonNull()) {
            return Optional.empty();
        }
        return Optional.of((CriterionTriggerProperties)SystemUtils.getOrThrow(CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)var0), JsonParseException::new));
    }

    public JsonElement serializeToJson() {
        return (JsonElement)SystemUtils.getOrThrow(CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this), IllegalStateException::new);
    }

    record c(String name, e valueMatcher) {
        public <S extends IBlockDataHolder<?, S>> boolean match(BlockStateList<?, S> var0, S var1) {
            IBlockState<?> var2 = var0.getProperty(this.name);
            return var2 != null && this.valueMatcher.match(var1, var2);
        }

        public Optional<String> checkState(BlockStateList<?, ?> var0) {
            IBlockState<?> var1 = var0.getProperty(this.name);
            return var1 != null ? Optional.empty() : Optional.of(this.name);
        }
    }

    static interface e {
        public static final Codec<e> CODEC = Codec.either(b.CODEC, d.CODEC).xmap(var02 -> (e)var02.map(var0 -> var0, var0 -> var0), var0 -> {
            if (var0 instanceof b) {
                b var1 = (b)var0;
                return Either.left((Object)var1);
            }
            if (var0 instanceof d) {
                d var2 = (d)var0;
                return Either.right((Object)var2);
            }
            throw new UnsupportedOperationException();
        });

        public <T extends Comparable<T>> boolean match(IBlockDataHolder<?, ?> var1, IBlockState<T> var2);
    }

    public static class a {
        private final ImmutableList.Builder<c> matchers = ImmutableList.builder();

        private a() {
        }

        public static a properties() {
            return new a();
        }

        public a hasProperty(IBlockState<?> var0, String var1) {
            this.matchers.add((Object)new c(var0.getName(), new b(var1)));
            return this;
        }

        public a hasProperty(IBlockState<Integer> var0, int var1) {
            return this.hasProperty((IBlockState)var0, (Comparable<T> & INamable)Integer.toString(var1));
        }

        public a hasProperty(IBlockState<Boolean> var0, boolean var1) {
            return this.hasProperty((IBlockState)var0, (Comparable<T> & INamable)Boolean.toString(var1));
        }

        public <T extends Comparable<T> & INamable> a hasProperty(IBlockState<T> var0, T var1) {
            return this.hasProperty(var0, (T)((INamable)var1).getSerializedName());
        }

        public Optional<CriterionTriggerProperties> build() {
            return Optional.of(new CriterionTriggerProperties((List<c>)this.matchers.build()));
        }
    }

    record d(Optional<String> minValue, Optional<String> maxValue) implements e
    {
        public static final Codec<d> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.strictOptionalField(Codec.STRING, "min").forGetter(d::minValue), (App)ExtraCodecs.strictOptionalField(Codec.STRING, "max").forGetter(d::maxValue)).apply((Applicative)var0, d::new));

        @Override
        public <T extends Comparable<T>> boolean match(IBlockDataHolder<?, ?> var0, IBlockState<T> var1) {
            Optional<T> var3;
            Comparable var2 = var0.getValue(var1);
            if (this.minValue.isPresent() && ((var3 = var1.getValue(this.minValue.get())).isEmpty() || var2.compareTo((Comparable)((Comparable)var3.get())) < 0)) {
                return false;
            }
            return !this.maxValue.isPresent() || !(var3 = var1.getValue(this.maxValue.get())).isEmpty() && var2.compareTo((Comparable)((Comparable)var3.get())) <= 0;
        }
    }

    record b(String value) implements e
    {
        public static final Codec<b> CODEC = Codec.STRING.xmap(b::new, b::value);

        @Override
        public <T extends Comparable<T>> boolean match(IBlockDataHolder<?, ?> var0, IBlockState<T> var1) {
            Comparable var2 = var0.getValue(var1);
            Optional<T> var3 = var1.getValue(this.value);
            return var3.isPresent() && var2.compareTo((Comparable)((Comparable)var3.get())) == 0;
        }
    }
}

