/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootTableInfo;

public class CriterionTriggerKilledByCrossbow
extends CriterionTriggerAbstract<a> {
    @Override
    public a createInstance(JsonObject var0, Optional<ContextAwarePredicate> var1, LootDeserializationContext var2) {
        List<ContextAwarePredicate> var3 = CriterionConditionEntity.fromJsonArray(var0, "victims", var2);
        CriterionConditionValue.IntegerRange var4 = CriterionConditionValue.IntegerRange.fromJson(var0.get("unique_entity_types"));
        return new a(var1, var3, var4);
    }

    @Override
    public void trigger(EntityPlayer var0, Collection<Entity> var1) {
        ArrayList var22 = Lists.newArrayList();
        HashSet var3 = Sets.newHashSet();
        for (Entity var5 : var1) {
            var3.add(var5.getType());
            var22.add(CriterionConditionEntity.createContext(var0, var5));
        }
        this.trigger(var0, (T var2) -> var2.matches(var22, var3.size()));
    }

    @Override
    public /* synthetic */ CriterionTriggerAbstract.a createInstance(JsonObject jsonObject, Optional optional, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, optional, lootDeserializationContext);
    }

    public static class a
    extends CriterionInstanceAbstract {
        private final List<ContextAwarePredicate> victims;
        private final CriterionConditionValue.IntegerRange uniqueEntityTypes;

        public a(Optional<ContextAwarePredicate> var0, List<ContextAwarePredicate> var1, CriterionConditionValue.IntegerRange var2) {
            super(var0);
            this.victims = var1;
            this.uniqueEntityTypes = var2;
        }

        public static Criterion<a> crossbowKilled(CriterionConditionEntity.a ... var0) {
            return CriterionTriggers.KILLED_BY_CROSSBOW.createCriterion(new a(Optional.empty(), CriterionConditionEntity.wrap(var0), CriterionConditionValue.IntegerRange.ANY));
        }

        public static Criterion<a> crossbowKilled(CriterionConditionValue.IntegerRange var0) {
            return CriterionTriggers.KILLED_BY_CROSSBOW.createCriterion(new a(Optional.empty(), List.of(), var0));
        }

        public boolean matches(Collection<LootTableInfo> var0, int var1) {
            if (!this.victims.isEmpty()) {
                ArrayList var2 = Lists.newArrayList(var0);
                for (ContextAwarePredicate var4 : this.victims) {
                    boolean var5 = false;
                    Iterator var6 = var2.iterator();
                    while (var6.hasNext()) {
                        LootTableInfo var7 = (LootTableInfo)var6.next();
                        if (!var4.matches(var7)) continue;
                        var6.remove();
                        var5 = true;
                        break;
                    }
                    if (var5) continue;
                    return false;
                }
            }
            return this.uniqueEntityTypes.matches(var1);
        }

        @Override
        public JsonObject serializeToJson() {
            JsonObject var0 = super.serializeToJson();
            var0.add("victims", ContextAwarePredicate.toJson(this.victims));
            var0.add("unique_entity_types", this.uniqueEntityTypes.serializeToJson());
            return var0;
        }
    }
}

