/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IMaterial;

public class CriterionTriggerInventoryChanged
extends CriterionTriggerAbstract<a> {
    @Override
    public a createInstance(JsonObject var0, Optional<ContextAwarePredicate> var1, LootDeserializationContext var2) {
        JsonObject var3 = ChatDeserializer.getAsJsonObject(var0, "slots", new JsonObject());
        CriterionConditionValue.IntegerRange var4 = CriterionConditionValue.IntegerRange.fromJson(var3.get("occupied"));
        CriterionConditionValue.IntegerRange var5 = CriterionConditionValue.IntegerRange.fromJson(var3.get("full"));
        CriterionConditionValue.IntegerRange var6 = CriterionConditionValue.IntegerRange.fromJson(var3.get("empty"));
        List<CriterionConditionItem> var7 = CriterionConditionItem.fromJsonArray(var0.get("items"));
        return new a(var1, var4, var5, var6, var7);
    }

    public void trigger(EntityPlayer var0, PlayerInventory var1, ItemStack var2) {
        int var3 = 0;
        int var4 = 0;
        int var5 = 0;
        for (int var6 = 0; var6 < var1.getContainerSize(); ++var6) {
            ItemStack var7 = var1.getItem(var6);
            if (var7.isEmpty()) {
                ++var4;
                continue;
            }
            ++var5;
            if (var7.getCount() < var7.getMaxStackSize()) continue;
            ++var3;
        }
        this.trigger(var0, var1, var2, var3, var4, var5);
    }

    private void trigger(EntityPlayer var0, PlayerInventory var1, ItemStack var2, int var3, int var4, int var52) {
        this.trigger(var0, var5 -> var5.matches(var1, var2, var3, var4, var52));
    }

    @Override
    public /* synthetic */ CriterionTriggerAbstract.a createInstance(JsonObject jsonObject, Optional optional, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, optional, lootDeserializationContext);
    }

    public static class a
    extends CriterionInstanceAbstract {
        private final CriterionConditionValue.IntegerRange slotsOccupied;
        private final CriterionConditionValue.IntegerRange slotsFull;
        private final CriterionConditionValue.IntegerRange slotsEmpty;
        private final List<CriterionConditionItem> predicates;

        public a(Optional<ContextAwarePredicate> var0, CriterionConditionValue.IntegerRange var1, CriterionConditionValue.IntegerRange var2, CriterionConditionValue.IntegerRange var3, List<CriterionConditionItem> var4) {
            super(var0);
            this.slotsOccupied = var1;
            this.slotsFull = var2;
            this.slotsEmpty = var3;
            this.predicates = var4;
        }

        public static Criterion<a> hasItems(CriterionConditionItem.a ... var0) {
            return a.hasItems((CriterionConditionItem[])Stream.of(var0).map(CriterionConditionItem.a::build).toArray(CriterionConditionItem[]::new));
        }

        public static Criterion<a> hasItems(CriterionConditionItem ... var0) {
            return CriterionTriggers.INVENTORY_CHANGED.createCriterion(new a(Optional.empty(), CriterionConditionValue.IntegerRange.ANY, CriterionConditionValue.IntegerRange.ANY, CriterionConditionValue.IntegerRange.ANY, List.of(var0)));
        }

        public static Criterion<a> hasItems(IMaterial ... var0) {
            CriterionConditionItem[] var1 = new CriterionConditionItem[var0.length];
            for (int var2 = 0; var2 < var0.length; ++var2) {
                var1[var2] = new CriterionConditionItem(Optional.empty(), Optional.of(HolderSet.direct(var0[var2].asItem().builtInRegistryHolder())), CriterionConditionValue.IntegerRange.ANY, CriterionConditionValue.IntegerRange.ANY, List.of(), List.of(), Optional.empty(), Optional.empty());
            }
            return a.hasItems(var1);
        }

        @Override
        public JsonObject serializeToJson() {
            JsonObject var0 = super.serializeToJson();
            if (!(this.slotsOccupied.isAny() && this.slotsFull.isAny() && this.slotsEmpty.isAny())) {
                JsonObject var1 = new JsonObject();
                var1.add("occupied", this.slotsOccupied.serializeToJson());
                var1.add("full", this.slotsFull.serializeToJson());
                var1.add("empty", this.slotsEmpty.serializeToJson());
                var0.add("slots", (JsonElement)var1);
            }
            if (!this.predicates.isEmpty()) {
                var0.add("items", CriterionConditionItem.serializeToJsonArray(this.predicates));
            }
            return var0;
        }

        public boolean matches(PlayerInventory var0, ItemStack var12, int var2, int var3, int var4) {
            if (!this.slotsFull.matches(var2)) {
                return false;
            }
            if (!this.slotsEmpty.matches(var3)) {
                return false;
            }
            if (!this.slotsOccupied.matches(var4)) {
                return false;
            }
            if (this.predicates.isEmpty()) {
                return true;
            }
            if (this.predicates.size() == 1) {
                return !var12.isEmpty() && this.predicates.get(0).matches(var12);
            }
            ObjectArrayList var5 = new ObjectArrayList(this.predicates);
            int var6 = var0.getContainerSize();
            for (int var7 = 0; var7 < var6; ++var7) {
                if (var5.isEmpty()) {
                    return true;
                }
                ItemStack var8 = var0.getItem(var7);
                if (var8.isEmpty()) continue;
                var5.removeIf(var1 -> var1.matches(var8));
            }
            return var5.isEmpty();
        }
    }
}

