/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;

public class CriterionTriggerFishingRodHooked
extends CriterionTriggerAbstract<a> {
    @Override
    public a createInstance(JsonObject var0, Optional<ContextAwarePredicate> var1, LootDeserializationContext var2) {
        Optional<CriterionConditionItem> var3 = CriterionConditionItem.fromJson(var0.get("rod"));
        Optional<ContextAwarePredicate> var4 = CriterionConditionEntity.fromJson(var0, "entity", var2);
        Optional<CriterionConditionItem> var5 = CriterionConditionItem.fromJson(var0.get("item"));
        return new a(var1, var3, var4, var5);
    }

    public void trigger(EntityPlayer var0, ItemStack var1, EntityFishingHook var2, Collection<ItemStack> var32) {
        LootTableInfo var4 = CriterionConditionEntity.createContext(var0, var2.getHookedIn() != null ? var2.getHookedIn() : var2);
        this.trigger(var0, var3 -> var3.matches(var1, var4, var32));
    }

    @Override
    public /* synthetic */ CriterionTriggerAbstract.a createInstance(JsonObject jsonObject, Optional optional, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, optional, lootDeserializationContext);
    }

    public static class a
    extends CriterionInstanceAbstract {
        private final Optional<CriterionConditionItem> rod;
        private final Optional<ContextAwarePredicate> entity;
        private final Optional<CriterionConditionItem> item;

        public a(Optional<ContextAwarePredicate> var0, Optional<CriterionConditionItem> var1, Optional<ContextAwarePredicate> var2, Optional<CriterionConditionItem> var3) {
            super(var0);
            this.rod = var1;
            this.entity = var2;
            this.item = var3;
        }

        public static Criterion<a> fishedItem(Optional<CriterionConditionItem> var0, Optional<CriterionConditionEntity> var1, Optional<CriterionConditionItem> var2) {
            return CriterionTriggers.FISHING_ROD_HOOKED.createCriterion(new a(Optional.empty(), var0, CriterionConditionEntity.wrap(var1), var2));
        }

        public boolean matches(ItemStack var0, LootTableInfo var1, Collection<ItemStack> var2) {
            if (this.rod.isPresent() && !this.rod.get().matches(var0)) {
                return false;
            }
            if (this.entity.isPresent() && !this.entity.get().matches(var1)) {
                return false;
            }
            if (this.item.isPresent()) {
                boolean var3 = false;
                Entity var4 = var1.getParamOrNull(LootContextParameters.THIS_ENTITY);
                if (var4 instanceof EntityItem) {
                    EntityItem var5 = (EntityItem)var4;
                    if (this.item.get().matches(var5.getItem())) {
                        var3 = true;
                    }
                }
                for (ItemStack var6 : var2) {
                    if (!this.item.get().matches(var6)) continue;
                    var3 = true;
                    break;
                }
                if (!var3) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public JsonObject serializeToJson() {
            JsonObject var0 = super.serializeToJson();
            this.rod.ifPresent(var1 -> var0.add("rod", var1.serializeToJson()));
            this.entity.ifPresent(var1 -> var0.add("entity", var1.toJson()));
            this.item.ifPresent(var1 -> var0.add("item", var1.serializeToJson()));
            return var0;
        }
    }
}

