/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerProperties;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;

public class CriterionTriggerEnterBlock
extends CriterionTriggerAbstract<a> {
    @Override
    public a createInstance(JsonObject var0, Optional<ContextAwarePredicate> var1, LootDeserializationContext var2) {
        Block var3 = CriterionTriggerEnterBlock.deserializeBlock(var0);
        Optional<CriterionTriggerProperties> var4 = CriterionTriggerProperties.fromJson(var0.get("state"));
        if (var3 != null) {
            var4.ifPresent(var12 -> var12.checkState(var3.getStateDefinition(), var1 -> {
                throw new JsonSyntaxException("Block " + var3 + " has no property " + var1);
            }));
        }
        return new a(var1, var3, var4);
    }

    @Nullable
    private static Block deserializeBlock(JsonObject var0) {
        if (var0.has("block")) {
            MinecraftKey var1 = new MinecraftKey(ChatDeserializer.getAsString(var0, "block"));
            return (Block)BuiltInRegistries.BLOCK.getOptional(var1).orElseThrow(() -> new JsonSyntaxException("Unknown block type '" + var1 + "'"));
        }
        return null;
    }

    public void trigger(EntityPlayer var0, IBlockData var12) {
        this.trigger(var0, (T var1) -> var1.matches(var12));
    }

    @Override
    public /* synthetic */ CriterionTriggerAbstract.a createInstance(JsonObject jsonObject, Optional optional, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, optional, lootDeserializationContext);
    }

    public static class a
    extends CriterionInstanceAbstract {
        @Nullable
        private final Block block;
        private final Optional<CriterionTriggerProperties> state;

        public a(Optional<ContextAwarePredicate> var0, @Nullable Block var1, Optional<CriterionTriggerProperties> var2) {
            super(var0);
            this.block = var1;
            this.state = var2;
        }

        public static Criterion<a> entersBlock(Block var0) {
            return CriterionTriggers.ENTER_BLOCK.createCriterion(new a(Optional.empty(), var0, Optional.empty()));
        }

        @Override
        public JsonObject serializeToJson() {
            JsonObject var0 = super.serializeToJson();
            if (this.block != null) {
                var0.addProperty("block", BuiltInRegistries.BLOCK.getKey(this.block).toString());
            }
            this.state.ifPresent(var1 -> var0.add("state", var1.serializeToJson()));
            return var0;
        }

        public boolean matches(IBlockData var0) {
            if (this.block != null && !var0.is(this.block)) {
                return false;
            }
            return !this.state.isPresent() || this.state.get().matches(var0);
        }
    }
}

