/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.alchemy.PotionRegistry;

public class CriterionTriggerBrewedPotion
extends CriterionTriggerAbstract<a> {
    @Override
    public a createInstance(JsonObject var0, Optional<ContextAwarePredicate> var1, LootDeserializationContext var2) {
        PotionRegistry var3 = null;
        if (var0.has("potion")) {
            MinecraftKey var4 = new MinecraftKey(ChatDeserializer.getAsString(var0, "potion"));
            var3 = (PotionRegistry)BuiltInRegistries.POTION.getOptional(var4).orElseThrow(() -> new JsonSyntaxException("Unknown potion '" + var4 + "'"));
        }
        return new a(var1, var3);
    }

    public void trigger(EntityPlayer var0, PotionRegistry var12) {
        this.trigger(var0, (T var1) -> var1.matches(var12));
    }

    @Override
    public /* synthetic */ CriterionTriggerAbstract.a createInstance(JsonObject jsonObject, Optional optional, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, optional, lootDeserializationContext);
    }

    public static class a
    extends CriterionInstanceAbstract {
        @Nullable
        private final PotionRegistry potion;

        public a(Optional<ContextAwarePredicate> var0, @Nullable PotionRegistry var1) {
            super(var0);
            this.potion = var1;
        }

        public static Criterion<a> brewedPotion() {
            return CriterionTriggers.BREWED_POTION.createCriterion(new a(Optional.empty(), null));
        }

        public boolean matches(PotionRegistry var0) {
            return this.potion == null || this.potion == var0;
        }

        @Override
        public JsonObject serializeToJson() {
            JsonObject var0 = super.serializeToJson();
            if (this.potion != null) {
                var0.addProperty("potion", BuiltInRegistries.POTION.getKey(this.potion).toString());
            }
            return var0;
        }
    }
}

