/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;

public class CriterionTriggerBeeNestDestroyed
extends CriterionTriggerAbstract<a> {
    @Override
    public a createInstance(JsonObject var0, Optional<ContextAwarePredicate> var1, LootDeserializationContext var2) {
        Block var3 = CriterionTriggerBeeNestDestroyed.deserializeBlock(var0);
        Optional<CriterionConditionItem> var4 = CriterionConditionItem.fromJson(var0.get("item"));
        CriterionConditionValue.IntegerRange var5 = CriterionConditionValue.IntegerRange.fromJson(var0.get("num_bees_inside"));
        return new a(var1, var3, var4, var5);
    }

    @Nullable
    private static Block deserializeBlock(JsonObject var0) {
        if (var0.has("block")) {
            MinecraftKey var1 = new MinecraftKey(ChatDeserializer.getAsString(var0, "block"));
            return (Block)BuiltInRegistries.BLOCK.getOptional(var1).orElseThrow(() -> new JsonSyntaxException("Unknown block type '" + var1 + "'"));
        }
        return null;
    }

    public void trigger(EntityPlayer var0, IBlockData var1, ItemStack var2, int var32) {
        this.trigger(var0, var3 -> var3.matches(var1, var2, var32));
    }

    @Override
    public /* synthetic */ CriterionTriggerAbstract.a createInstance(JsonObject jsonObject, Optional optional, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, optional, lootDeserializationContext);
    }

    public static class a
    extends CriterionInstanceAbstract {
        @Nullable
        private final Block block;
        private final Optional<CriterionConditionItem> item;
        private final CriterionConditionValue.IntegerRange numBees;

        public a(Optional<ContextAwarePredicate> var0, @Nullable Block var1, Optional<CriterionConditionItem> var2, CriterionConditionValue.IntegerRange var3) {
            super(var0);
            this.block = var1;
            this.item = var2;
            this.numBees = var3;
        }

        public static Criterion<a> destroyedBeeNest(Block var0, CriterionConditionItem.a var1, CriterionConditionValue.IntegerRange var2) {
            return CriterionTriggers.BEE_NEST_DESTROYED.createCriterion(new a(Optional.empty(), var0, Optional.of(var1.build()), var2));
        }

        public boolean matches(IBlockData var0, ItemStack var1, int var2) {
            if (this.block != null && !var0.is(this.block)) {
                return false;
            }
            if (this.item.isPresent() && !this.item.get().matches(var1)) {
                return false;
            }
            return this.numBees.matches(var2);
        }

        @Override
        public JsonObject serializeToJson() {
            JsonObject var0 = super.serializeToJson();
            if (this.block != null) {
                var0.addProperty("block", BuiltInRegistries.BLOCK.getKey(this.block).toString());
            }
            this.item.ifPresent(var1 -> var0.add("item", var1.serializeToJson()));
            var0.add("num_bees_inside", this.numBees.serializeToJson());
            return var0;
        }
    }
}

