/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.ExtraCodecs;

public interface CriterionConditionValue<T extends Number> {
    public static final SimpleCommandExceptionType ERROR_EMPTY = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.range.empty"));
    public static final SimpleCommandExceptionType ERROR_SWAPPED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.range.swapped"));

    public Optional<T> min();

    public Optional<T> max();

    default public boolean isAny() {
        return this.min().isEmpty() && this.max().isEmpty();
    }

    default public Optional<T> unwrapPoint() {
        Optional<T> var1;
        Optional<T> var0 = this.min();
        return var0.equals(var1 = this.max()) ? var0 : Optional.empty();
    }

    public static <T extends Number, R extends CriterionConditionValue<T>> Codec<R> createCodec(Codec<T> var02, a<T, R> var1) {
        Codec var22 = RecordCodecBuilder.create(var2 -> var2.group((App)ExtraCodecs.strictOptionalField(var02, "min").forGetter(CriterionConditionValue::min), (App)ExtraCodecs.strictOptionalField(var02, "max").forGetter(CriterionConditionValue::max)).apply((Applicative)var2, var1::create));
        return Codec.either((Codec)var22, var02).xmap(var12 -> (CriterionConditionValue)var12.map(var0 -> var0, var1 -> var1.create(Optional.of(var1), Optional.of(var1))), var0 -> {
            Optional var1 = var0.unwrapPoint();
            return var1.isPresent() ? Either.right((Object)((Number)var1.get())) : Either.left((Object)var0);
        });
    }

    public static <T extends Number, R extends CriterionConditionValue<T>> R fromReader(StringReader var0, b<T, R> var1, Function<String, T> var2, Supplier<DynamicCommandExceptionType> var3, Function<T, T> var4) throws CommandSyntaxException {
        if (!var0.canRead()) {
            throw ERROR_EMPTY.createWithContext((ImmutableStringReader)var0);
        }
        int var5 = var0.getCursor();
        try {
            Optional<T> var7;
            Optional<T> var6 = CriterionConditionValue.readNumber(var0, var2, var3).map(var4);
            if (var0.canRead(2) && var0.peek() == '.' && var0.peek(1) == '.') {
                var0.skip();
                var0.skip();
                var7 = CriterionConditionValue.readNumber(var0, var2, var3).map(var4);
                if (var6.isEmpty() && var7.isEmpty()) {
                    throw ERROR_EMPTY.createWithContext((ImmutableStringReader)var0);
                }
            } else {
                var7 = var6;
            }
            if (var6.isEmpty() && var7.isEmpty()) {
                throw ERROR_EMPTY.createWithContext((ImmutableStringReader)var0);
            }
            return var1.create(var0, var6, var7);
        }
        catch (CommandSyntaxException var6) {
            var0.setCursor(var5);
            throw new CommandSyntaxException(var6.getType(), var6.getRawMessage(), var6.getInput(), var5);
        }
    }

    private static <T extends Number> Optional<T> readNumber(StringReader var0, Function<String, T> var1, Supplier<DynamicCommandExceptionType> var2) throws CommandSyntaxException {
        int var3 = var0.getCursor();
        while (var0.canRead() && CriterionConditionValue.isAllowedInputChat(var0)) {
            var0.skip();
        }
        String var4 = var0.getString().substring(var3, var0.getCursor());
        if (var4.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of((Number)var1.apply(var4));
        }
        catch (NumberFormatException var5) {
            throw var2.get().createWithContext((ImmutableStringReader)var0, (Object)var4);
        }
    }

    private static boolean isAllowedInputChat(StringReader var0) {
        char var1 = var0.peek();
        if (var1 >= '0' && var1 <= '9' || var1 == '-') {
            return true;
        }
        if (var1 == '.') {
            return !var0.canRead(2) || var0.peek(1) != '.';
        }
        return false;
    }

    @FunctionalInterface
    public static interface a<T extends Number, R extends CriterionConditionValue<T>> {
        public R create(Optional<T> var1, Optional<T> var2);
    }

    @FunctionalInterface
    public static interface b<T extends Number, R extends CriterionConditionValue<T>> {
        public R create(StringReader var1, Optional<T> var2, Optional<T> var3) throws CommandSyntaxException;
    }

    public record DoubleRange(Optional<Double> min, Optional<Double> max, Optional<Double> minSq, Optional<Double> maxSq) implements CriterionConditionValue<Double>
    {
        public static final DoubleRange ANY = new DoubleRange(Optional.empty(), Optional.empty());
        public static final Codec<DoubleRange> CODEC = CriterionConditionValue.createCodec(Codec.DOUBLE, DoubleRange::new);

        private DoubleRange(Optional<Double> var0, Optional<Double> var1) {
            this(var0, var1, DoubleRange.squareOpt(var0), DoubleRange.squareOpt(var1));
        }

        private static DoubleRange create(StringReader var0, Optional<Double> var1, Optional<Double> var2) throws CommandSyntaxException {
            if (var1.isPresent() && var2.isPresent() && var1.get() > var2.get()) {
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)var0);
            }
            return new DoubleRange(var1, var2);
        }

        private static Optional<Double> squareOpt(Optional<Double> var02) {
            return var02.map(var0 -> var0 * var0);
        }

        public static DoubleRange exactly(double var0) {
            return new DoubleRange(Optional.of(var0), Optional.of(var0));
        }

        public static DoubleRange between(double var0, double var2) {
            return new DoubleRange(Optional.of(var0), Optional.of(var2));
        }

        public static DoubleRange atLeast(double var0) {
            return new DoubleRange(Optional.of(var0), Optional.empty());
        }

        public static DoubleRange atMost(double var0) {
            return new DoubleRange(Optional.empty(), Optional.of(var0));
        }

        public boolean matches(double var0) {
            if (this.min.isPresent() && this.min.get() > var0) {
                return false;
            }
            return this.max.isEmpty() || !(this.max.get() < var0);
        }

        public boolean matchesSqr(double var0) {
            if (this.minSq.isPresent() && this.minSq.get() > var0) {
                return false;
            }
            return this.maxSq.isEmpty() || !(this.maxSq.get() < var0);
        }

        public static DoubleRange fromJson(@Nullable JsonElement var0) {
            if (var0 == null || var0.isJsonNull()) {
                return ANY;
            }
            return (DoubleRange)SystemUtils.getOrThrow(CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)var0), JsonParseException::new);
        }

        public JsonElement serializeToJson() {
            if (this.isAny()) {
                return JsonNull.INSTANCE;
            }
            return (JsonElement)SystemUtils.getOrThrow(CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this), IllegalStateException::new);
        }

        public static DoubleRange fromReader(StringReader var02) throws CommandSyntaxException {
            return DoubleRange.fromReader(var02, var0 -> var0);
        }

        public static DoubleRange fromReader(StringReader var0, Function<Double, Double> var1) throws CommandSyntaxException {
            return CriterionConditionValue.fromReader(var0, DoubleRange::create, Double::parseDouble, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidDouble(), var1);
        }
    }

    public record IntegerRange(Optional<Integer> min, Optional<Integer> max, Optional<Long> minSq, Optional<Long> maxSq) implements CriterionConditionValue<Integer>
    {
        public static final IntegerRange ANY = new IntegerRange(Optional.empty(), Optional.empty());
        public static final Codec<IntegerRange> CODEC = CriterionConditionValue.createCodec(Codec.INT, IntegerRange::new);

        private IntegerRange(Optional<Integer> var02, Optional<Integer> var1) {
            this(var02, var1, var02.map(var0 -> var0.longValue() * var0.longValue()), IntegerRange.squareOpt(var1));
        }

        private static IntegerRange create(StringReader var0, Optional<Integer> var1, Optional<Integer> var2) throws CommandSyntaxException {
            if (var1.isPresent() && var2.isPresent() && var1.get() > var2.get()) {
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)var0);
            }
            return new IntegerRange(var1, var2);
        }

        private static Optional<Long> squareOpt(Optional<Integer> var02) {
            return var02.map(var0 -> var0.longValue() * var0.longValue());
        }

        public static IntegerRange exactly(int var0) {
            return new IntegerRange(Optional.of(var0), Optional.of(var0));
        }

        public static IntegerRange between(int var0, int var1) {
            return new IntegerRange(Optional.of(var0), Optional.of(var1));
        }

        public static IntegerRange atLeast(int var0) {
            return new IntegerRange(Optional.of(var0), Optional.empty());
        }

        public static IntegerRange atMost(int var0) {
            return new IntegerRange(Optional.empty(), Optional.of(var0));
        }

        public boolean matches(int var0) {
            if (this.min.isPresent() && this.min.get() > var0) {
                return false;
            }
            return this.max.isEmpty() || this.max.get() >= var0;
        }

        public boolean matchesSqr(long var0) {
            if (this.minSq.isPresent() && this.minSq.get() > var0) {
                return false;
            }
            return this.maxSq.isEmpty() || this.maxSq.get() >= var0;
        }

        public static IntegerRange fromJson(@Nullable JsonElement var0) {
            if (var0 == null || var0.isJsonNull()) {
                return ANY;
            }
            return (IntegerRange)SystemUtils.getOrThrow(CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)var0), JsonParseException::new);
        }

        public JsonElement serializeToJson() {
            if (this.isAny()) {
                return JsonNull.INSTANCE;
            }
            return (JsonElement)SystemUtils.getOrThrow(CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this), IllegalStateException::new);
        }

        public static IntegerRange fromReader(StringReader var02) throws CommandSyntaxException {
            return IntegerRange.fromReader(var02, var0 -> var0);
        }

        public static IntegerRange fromReader(StringReader var0, Function<Integer, Integer> var1) throws CommandSyntaxException {
            return CriterionConditionValue.fromReader(var0, IntegerRange::create, Integer::parseInt, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidInt(), var1);
        }
    }
}

