/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.CriterionTriggerProperties;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;

public record CriterionConditionFluid(Optional<TagKey<FluidType>> tag, Optional<Holder<FluidType>> fluid, Optional<CriterionTriggerProperties> properties) {
    public static final Codec<CriterionConditionFluid> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.strictOptionalField(TagKey.codec(Registries.FLUID), "tag").forGetter(CriterionConditionFluid::tag), (App)ExtraCodecs.strictOptionalField(BuiltInRegistries.FLUID.holderByNameCodec(), "fluid").forGetter(CriterionConditionFluid::fluid), (App)ExtraCodecs.strictOptionalField(CriterionTriggerProperties.CODEC, "state").forGetter(CriterionConditionFluid::properties)).apply((Applicative)var0, CriterionConditionFluid::new));

    public boolean matches(WorldServer var0, BlockPosition var1) {
        if (!var0.isLoaded(var1)) {
            return false;
        }
        Fluid var2 = var0.getFluidState(var1);
        if (this.tag.isPresent() && !var2.is(this.tag.get())) {
            return false;
        }
        if (this.fluid.isPresent() && !var2.is(this.fluid.get().value())) {
            return false;
        }
        return !this.properties.isPresent() || this.properties.get().matches(var2);
    }

    public static class a {
        private Optional<Holder<FluidType>> fluid = Optional.empty();
        private Optional<TagKey<FluidType>> fluids = Optional.empty();
        private Optional<CriterionTriggerProperties> properties = Optional.empty();

        private a() {
        }

        public static a fluid() {
            return new a();
        }

        public a of(FluidType var0) {
            this.fluid = Optional.of(var0.builtInRegistryHolder());
            return this;
        }

        public a of(TagKey<FluidType> var0) {
            this.fluids = Optional.of(var0);
            return this;
        }

        public a setProperties(CriterionTriggerProperties var0) {
            this.properties = Optional.of(var0);
            return this;
        }

        public CriterionConditionFluid build() {
            return new CriterionConditionFluid(this.fluids, this.fluid, this.properties);
        }
    }
}

