/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.Items;

public record CriterionConditionEntityEquipment(Optional<CriterionConditionItem> head, Optional<CriterionConditionItem> chest, Optional<CriterionConditionItem> legs, Optional<CriterionConditionItem> feet, Optional<CriterionConditionItem> mainhand, Optional<CriterionConditionItem> offhand) {
    public static final Codec<CriterionConditionEntityEquipment> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.strictOptionalField(CriterionConditionItem.CODEC, "head").forGetter(CriterionConditionEntityEquipment::head), (App)ExtraCodecs.strictOptionalField(CriterionConditionItem.CODEC, "chest").forGetter(CriterionConditionEntityEquipment::chest), (App)ExtraCodecs.strictOptionalField(CriterionConditionItem.CODEC, "legs").forGetter(CriterionConditionEntityEquipment::legs), (App)ExtraCodecs.strictOptionalField(CriterionConditionItem.CODEC, "feet").forGetter(CriterionConditionEntityEquipment::feet), (App)ExtraCodecs.strictOptionalField(CriterionConditionItem.CODEC, "mainhand").forGetter(CriterionConditionEntityEquipment::mainhand), (App)ExtraCodecs.strictOptionalField(CriterionConditionItem.CODEC, "offhand").forGetter(CriterionConditionEntityEquipment::offhand)).apply((Applicative)var0, CriterionConditionEntityEquipment::new));
    public static final CriterionConditionEntityEquipment CAPTAIN = a.equipment().head(CriterionConditionItem.a.item().of(Items.WHITE_BANNER).hasNbt(Raid.getLeaderBannerInstance().getTag())).build();

    public boolean matches(@Nullable Entity var0) {
        if (!(var0 instanceof EntityLiving)) {
            return false;
        }
        EntityLiving var1 = (EntityLiving)var0;
        if (this.head.isPresent() && !this.head.get().matches(var1.getItemBySlot(EnumItemSlot.HEAD))) {
            return false;
        }
        if (this.chest.isPresent() && !this.chest.get().matches(var1.getItemBySlot(EnumItemSlot.CHEST))) {
            return false;
        }
        if (this.legs.isPresent() && !this.legs.get().matches(var1.getItemBySlot(EnumItemSlot.LEGS))) {
            return false;
        }
        if (this.feet.isPresent() && !this.feet.get().matches(var1.getItemBySlot(EnumItemSlot.FEET))) {
            return false;
        }
        if (this.mainhand.isPresent() && !this.mainhand.get().matches(var1.getItemBySlot(EnumItemSlot.MAINHAND))) {
            return false;
        }
        return !this.offhand.isPresent() || this.offhand.get().matches(var1.getItemBySlot(EnumItemSlot.OFFHAND));
    }

    public static class a {
        private Optional<CriterionConditionItem> head = Optional.empty();
        private Optional<CriterionConditionItem> chest = Optional.empty();
        private Optional<CriterionConditionItem> legs = Optional.empty();
        private Optional<CriterionConditionItem> feet = Optional.empty();
        private Optional<CriterionConditionItem> mainhand = Optional.empty();
        private Optional<CriterionConditionItem> offhand = Optional.empty();

        public static a equipment() {
            return new a();
        }

        public a head(CriterionConditionItem.a var0) {
            this.head = Optional.of(var0.build());
            return this;
        }

        public a chest(CriterionConditionItem.a var0) {
            this.chest = Optional.of(var0.build());
            return this;
        }

        public a legs(CriterionConditionItem.a var0) {
            this.legs = Optional.of(var0.build());
            return this;
        }

        public a feet(CriterionConditionItem.a var0) {
            this.feet = Optional.of(var0.build());
            return this;
        }

        public a mainhand(CriterionConditionItem.a var0) {
            this.mainhand = Optional.of(var0.build());
            return this;
        }

        public a offhand(CriterionConditionItem.a var0) {
            this.offhand = Optional.of(var0.build());
            return this;
        }

        public CriterionConditionEntityEquipment build() {
            return new CriterionConditionEntityEquipment(this.head, this.chest, this.legs, this.feet, this.mainhand, this.offhand);
        }
    }
}

