/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.enchantment.Enchantment;

public record CriterionConditionEnchantments(Optional<Holder<Enchantment>> enchantment, CriterionConditionValue.IntegerRange level) {
    public static final Codec<CriterionConditionEnchantments> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.strictOptionalField(BuiltInRegistries.ENCHANTMENT.holderByNameCodec(), "enchantment").forGetter(CriterionConditionEnchantments::enchantment), (App)ExtraCodecs.strictOptionalField(CriterionConditionValue.IntegerRange.CODEC, "levels", CriterionConditionValue.IntegerRange.ANY).forGetter(CriterionConditionEnchantments::level)).apply((Applicative)var0, CriterionConditionEnchantments::new));

    public CriterionConditionEnchantments(Enchantment var0, CriterionConditionValue.IntegerRange var1) {
        this(Optional.of(var0.builtInRegistryHolder()), var1);
    }

    public boolean containedIn(Map<Enchantment, Integer> var0) {
        if (this.enchantment.isPresent()) {
            Enchantment var1 = this.enchantment.get().value();
            if (!var0.containsKey(var1)) {
                return false;
            }
            int var2 = var0.get(var1);
            if (this.level != CriterionConditionValue.IntegerRange.ANY && !this.level.matches(var2)) {
                return false;
            }
        } else if (this.level != CriterionConditionValue.IntegerRange.ANY) {
            for (Integer var2 : var0.values()) {
                if (!this.level.matches(var2)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

